/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Sort
extends SingleRel {
    public final RelCollation collation;
    public final @Nullable RexNode offset;
    public final @Nullable RexNode fetch;

    protected Sort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation) {
        this(cluster, traits, child, collation, null, null);
    }

    protected Sort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traits, child);
        this.collation = collation;
        this.offset = offset;
        this.fetch = fetch;
        assert (traits.containsIfApplicable(collation)) : "traits=" + traits + ", collation=" + collation;
        assert (fetch != null || offset != null || !collation.getFieldCollations().isEmpty()) : "trivial sort";
    }

    protected Sort(RelInput input) {
        this(input.getCluster(), input.getTraitSet().plus(input.getCollation()), input.getInput(), RelCollationTraitDef.INSTANCE.canonize(input.getCollation()), input.getExpression("offset"), input.getExpression("fetch"));
    }

    @Override
    public final Sort copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Sort.sole(inputs), this.collation, this.offset, this.fetch);
    }

    public final Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation) {
        return this.copy(traitSet, newInput, newCollation, this.offset, this.fetch);
    }

    public abstract Sort copy(RelTraitSet var1, RelNode var2, RelCollation var3, @Nullable RexNode var4, @Nullable RexNode var5);

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double readCount;
        double offsetValue = Util.first(Sort.doubleValue(this.offset), 0.0);
        assert (offsetValue >= 0.0) : "offset should not be negative:" + offsetValue;
        double inCount = mq.getRowCount(this.input);
        @Nullable Double fetchValue = Sort.doubleValue(this.fetch);
        if (fetchValue == null) {
            readCount = inCount;
        } else {
            if (fetchValue <= 0.0) {
                return planner.getCostFactory().makeCost(inCount, 0.0, 0.0);
            }
            readCount = Math.min(inCount, offsetValue + fetchValue);
        }
        double bytesPerRow = (3 + this.getRowType().getFieldCount()) * 4;
        double cpu = this.collation.getFieldCollations().isEmpty() ? readCount * bytesPerRow : Util.nLogM(inCount, readCount) * bytesPerRow;
        return planner.getCostFactory().makeCost(readCount, cpu, 0.0);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode offset = shuttle.apply(this.offset);
        RexNode fetch = shuttle.apply(this.fetch);
        List<RexNode> originalSortExps = this.getSortExps();
        List<RexNode> sortExps = shuttle.apply(originalSortExps);
        assert (sortExps == originalSortExps) : "Sort node does not support modification of input field expressions. Old expressions: " + originalSortExps + ", new ones: " + sortExps;
        if (offset == this.offset && fetch == this.fetch) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), this.collation, offset, fetch);
    }

    @Override
    public boolean isEnforcer() {
        return this.offset == null && this.fetch == null && this.collation.getFieldCollations().size() > 0;
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    public List<RexNode> getSortExps() {
        return Util.transform(this.collation.getFieldCollations(), field -> this.getCluster().getRexBuilder().makeInputRef(this.input, Objects.requireNonNull(field, "field").getFieldIndex()));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.nest()) {
            pw.item("collation", this.collation);
        } else {
            for (Ord<RexNode> ord : Ord.zip(this.getSortExps())) {
                pw.item("sort" + ord.i, ord.e);
            }
            for (Ord<Object> ord : Ord.zip(this.collation.getFieldCollations())) {
                pw.item("dir" + ord.i, ((RelFieldCollation)ord.e).shortString());
            }
        }
        pw.itemIf("offset", this.offset, this.offset != null);
        pw.itemIf("fetch", this.fetch, this.fetch != null);
        return pw;
    }

    private static @Nullable Double doubleValue(@Nullable RexNode r) {
        return r instanceof RexLiteral ? ((RexLiteral)r).getValueAs(Double.class) : null;
    }
}

