/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingList;
import com.google.uzaygezen.core.NodeList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;

final class LinkedNodeList<E>
extends AbstractSequentialList<E>
implements NodeList<E>,
Queue<E>,
Serializable {
    private transient int size;
    private transient NodeImpl<E> head;
    private transient NodeImpl<E> tail;
    private static final long serialVersionUID = 0L;

    private LinkedNodeList() {
    }

    private LinkedNodeList(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    public static <E> LinkedNodeList<E> create() {
        return new LinkedNodeList<E>();
    }

    public static <E> LinkedNodeList<E> create(Collection<? extends E> collection) {
        return new LinkedNodeList<E>(collection);
    }

    @Override
    public void add(int index, E e) {
        this.addAndGetNode(index, e);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new IteratorImpl(index);
    }

    @Override
    public E remove(int index) {
        NodeList.Node node = this.getNode(index);
        node.remove();
        return node.get();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(Preconditions.checkNotNull(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(Preconditions.checkNotNull(c));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        final List delegate = super.subList(fromIndex, toIndex);
        return new ForwardingList<E>(){

            @Override
            protected List<E> delegate() {
                return delegate;
            }
        };
    }

    @Override
    public NodeList.Node<E> addAndGetNode(E e) {
        return this.addAndGetNode(this.size, e);
    }

    @Override
    public NodeList.Node<E> addAndGetNode(int index, E e) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
        if (this.head == null) {
            NodeImpl<E> node = new NodeImpl<E>(e, null, null, this);
            this.head = node;
            this.tail = node;
            return node;
        }
        if (index < this.size) {
            return ((NodeImpl)this.getNode(index)).addBefore(e);
        }
        return this.tail.addAfter(e);
    }

    @Override
    public NodeImpl<E> getNode(int index) {
        NodeImpl<E> node;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
        if (index < this.size / 2) {
            node = this.head;
            for (int i = 0; i < index; ++i) {
                node = node.next;
            }
        } else {
            node = this.tail;
            for (int i = this.size - 1; i > index; --i) {
                node = node.previous;
            }
        }
        return node;
    }

    @Override
    public NodeList.Node<E> nodeWith(Object o) {
        for (NodeList.Node<E> node = this.head; node != null; node = node.next()) {
            if (!node.get().equals(o)) continue;
            return node;
        }
        return null;
    }

    @Override
    public NodeList.Node<E> lastNodeWith(Object o) {
        for (NodeList.Node<E> node = this.tail; node != null; node = node.previous()) {
            if (!node.get().equals(o)) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean concat(NodeList<E> nodeList) {
        Preconditions.checkArgument(nodeList != this);
        LinkedNodeList other = (LinkedNodeList)nodeList;
        if (other.isEmpty()) {
            return false;
        }
        if (this.isEmpty()) {
            this.head = other.head;
        } else {
            this.tail.next = other.head;
            other.head.previous = this.tail;
        }
        this.tail = other.tail;
        this.size += other.size;
        ++this.modCount;
        NodeImpl<E> node = other.head;
        while (node != null) {
            node.list = this;
            node = node.next;
        }
        other.head = null;
        other.tail = null;
        other.size = 0;
        ++other.modCount;
        return true;
    }

    @Override
    public E element() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.get();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E peek() {
        return this.head == null ? null : (E)this.head.get();
    }

    @Override
    public E poll() {
        if (this.head == null) {
            return null;
        }
        E element = this.head.get();
        this.head.remove();
        return element;
    }

    @Override
    public E remove() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        E element = this.head.get();
        this.head.remove();
        return element;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Object[] array;
        stream.defaultReadObject();
        for (Object element : array = (Object[])stream.readObject()) {
            this.add(element);
        }
    }

    private class IteratorImpl
    implements ListIterator<E> {
        int nextIndex;
        NodeImpl<E> nextNode;
        NodeImpl<E> toUpdate;
        int iteratorModCount;

        IteratorImpl(int index) {
            this.iteratorModCount = LinkedNodeList.this.modCount;
            if (index < 0 || index > LinkedNodeList.this.size) {
                throw new IndexOutOfBoundsException("Invalid index " + index);
            }
            this.nextIndex = index;
        }

        IteratorImpl(NodeImpl<E> node) {
            this.iteratorModCount = LinkedNodeList.this.modCount;
            this.nextIndex = node.index();
            this.nextNode = node;
        }

        @Override
        public void add(E e) {
            this.checkConcurrentModification();
            if (this.nextNode == null) {
                LinkedNodeList.this.add(this.nextIndex, e);
            } else {
                this.nextNode.addBefore(e);
            }
            this.toUpdate = null;
            ++this.nextIndex;
            this.iteratorModCount = LinkedNodeList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.checkConcurrentModification();
            return this.nextIndex < LinkedNodeList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            this.checkConcurrentModification();
            return this.nextIndex > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.toUpdate = this.nextNode == null ? LinkedNodeList.this.getNode(this.nextIndex) : this.nextNode;
            this.nextNode = this.toUpdate.next;
            ++this.nextIndex;
            return this.toUpdate.get();
        }

        @Override
        public int nextIndex() {
            this.checkConcurrentModification();
            return this.nextIndex;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.toUpdate = this.nextNode == null ? LinkedNodeList.this.getNode(this.nextIndex - 1) : this.nextNode.previous;
            this.nextNode = this.toUpdate;
            --this.nextIndex;
            return this.toUpdate.get();
        }

        @Override
        public int previousIndex() {
            this.checkConcurrentModification();
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkConcurrentModification();
            Preconditions.checkState(this.toUpdate != null);
            Preconditions.checkState(this.toUpdate.list != null);
            this.toUpdate.remove();
            if (this.toUpdate == this.nextNode) {
                this.nextNode = this.nextNode.next;
            } else {
                --this.nextIndex;
            }
            this.toUpdate = null;
            this.iteratorModCount = LinkedNodeList.this.modCount;
        }

        @Override
        public void set(E e) {
            this.checkConcurrentModification();
            Preconditions.checkState(this.toUpdate != null);
            this.toUpdate.set(Preconditions.checkNotNull(e));
        }

        void checkConcurrentModification() {
            if (this.iteratorModCount != LinkedNodeList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class NodeImpl<E>
    implements NodeList.Node<E> {
        E element;
        NodeImpl<E> previous;
        NodeImpl<E> next;
        LinkedNodeList<E> list;

        NodeImpl(E element, NodeImpl<E> previous, NodeImpl<E> next, LinkedNodeList<E> list) {
            this.element = Preconditions.checkNotNull(element);
            this.previous = previous;
            this.next = next;
            this.list = list;
            ((LinkedNodeList)list).size++;
            ((LinkedNodeList)list).modCount++;
        }

        @Override
        public NodeList.Node<E> addAfter(E e) {
            NodeImpl<E> node;
            Preconditions.checkState(this.list != null);
            if (this == ((LinkedNodeList)this.list).tail) {
                node = new NodeImpl<E>(e, ((LinkedNodeList)this.list).tail, null, this.list);
                ((LinkedNodeList)this.list).tail.next = node;
                ((LinkedNodeList)this.list).tail = node;
            } else {
                node = new NodeImpl<E>(e, this, this.next, this.list);
                this.next.previous = node;
                this.next = node;
            }
            return node;
        }

        @Override
        public NodeList.Node<E> addBefore(E e) {
            NodeImpl<E> node;
            Preconditions.checkState(this.list != null);
            if (this == ((LinkedNodeList)this.list).head) {
                node = new NodeImpl<E>(e, null, ((LinkedNodeList)this.list).head, this.list);
                ((LinkedNodeList)this.list).head.previous = node;
                ((LinkedNodeList)this.list).head = node;
            } else {
                node = new NodeImpl<E>(e, this.previous, this, this.list);
                this.previous.next = node;
                this.previous = node;
            }
            return node;
        }

        @Override
        public E get() {
            return this.element;
        }

        @Override
        public int index() {
            Preconditions.checkState(this.list != null);
            int index = 0;
            for (NodeList.Node<E> node = ((LinkedNodeList)this.list).head; node != this; node = node.next()) {
                ++index;
            }
            return index;
        }

        @Override
        public NodeList<E> list() {
            return this.list;
        }

        @Override
        public ListIterator<E> listIterator() {
            Preconditions.checkState(this.list != null);
            LinkedNodeList<E> linkedNodeList = this.list;
            linkedNodeList.getClass();
            return linkedNodeList.new IteratorImpl(this);
        }

        @Override
        public NodeList.Node<E> next() {
            return this.next;
        }

        @Override
        public NodeList.Node<E> previous() {
            return this.previous;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.list != null);
            this.removeNode();
            ((LinkedNodeList)this.list).size--;
            ((LinkedNodeList)this.list).modCount++;
            this.list = null;
        }

        private void removeNode() {
            if (this == ((LinkedNodeList)this.list).head) {
                ((LinkedNodeList)this.list).head = this.next;
            } else {
                this.previous.next = this.next;
            }
            if (this == ((LinkedNodeList)this.list).tail) {
                ((LinkedNodeList)this.list).tail = this.previous;
            } else {
                this.next.previous = this.previous;
            }
        }

        @Override
        public E set(E e) {
            E old = this.element;
            this.element = Preconditions.checkNotNull(e);
            return old;
        }

        @Override
        public boolean moveToStart() {
            Preconditions.checkState(this.list != null);
            if (this == ((LinkedNodeList)this.list).head) {
                return false;
            }
            this.removeNode();
            this.next = ((LinkedNodeList)this.list).head;
            this.previous = null;
            ((LinkedNodeList)this.list).head.previous = this;
            ((LinkedNodeList)this.list).head = this;
            ((LinkedNodeList)this.list).modCount++;
            return true;
        }

        @Override
        public boolean moveToEnd() {
            Preconditions.checkState(this.list != null);
            if (this == ((LinkedNodeList)this.list).tail) {
                return false;
            }
            this.removeNode();
            this.next = null;
            this.previous = ((LinkedNodeList)this.list).tail;
            ((LinkedNodeList)this.list).tail.next = this;
            ((LinkedNodeList)this.list).tail = this;
            ((LinkedNodeList)this.list).modCount++;
            return true;
        }

        @Override
        public boolean swap(NodeList.Node<E> node) {
            if (this == node) {
                return false;
            }
            NodeImpl other = (NodeImpl)node;
            if (this.list == null && other.list == null) {
                return false;
            }
            if (this.list == null) {
                NodeImpl.swapOneRemoved(other, this);
            } else if (other.list == null) {
                NodeImpl.swapOneRemoved(this, other);
            } else if (other == this.next) {
                this.swapWithNext();
            } else if (other == this.previous) {
                other.swapWithNext();
            } else {
                NodeImpl.swapNonAdjacent(this, other);
            }
            this.updateAfterSwap();
            other.updateAfterSwap();
            return true;
        }

        private static <E> void swapOneRemoved(NodeImpl<E> present, NodeImpl<E> removed) {
            removed.previous = present.previous;
            removed.next = present.next;
            removed.list = present.list;
            present.list = null;
        }

        private void swapWithNext() {
            NodeImpl<E> originalNext = this.next;
            originalNext.previous = this.previous;
            this.next = originalNext.next;
            originalNext.next = this;
            this.previous = originalNext;
        }

        private static <E> void swapNonAdjacent(NodeImpl<E> first, NodeImpl<E> second) {
            NodeImpl<E> oldPrevious = first.previous;
            first.previous = second.previous;
            second.previous = oldPrevious;
            NodeImpl<E> oldNext = first.next;
            first.next = second.next;
            second.next = oldNext;
            LinkedNodeList<E> oldList = first.list;
            first.list = second.list;
            second.list = oldList;
        }

        private void updateAfterSwap() {
            if (this.list != null) {
                if (this.previous == null) {
                    ((LinkedNodeList)this.list).head = this;
                } else {
                    this.previous.next = this;
                }
                if (this.next == null) {
                    ((LinkedNodeList)this.list).tail = this;
                } else {
                    this.next.previous = this;
                }
                ((LinkedNodeList)this.list).modCount++;
            }
        }

        @Override
        public NodeList<E> splitBefore() {
            Preconditions.checkState(this.list != null);
            LinkedNodeList<E> first = this.list;
            LinkedNodeList second = new LinkedNodeList();
            NodeImpl<E> node = this;
            while (node != null) {
                node.list = second;
                second.size++;
                node = node.next;
            }
            ((LinkedNodeList)first).size -= second.size;
            ((LinkedNodeList)first).modCount++;
            second.head = this;
            second.tail = ((LinkedNodeList)first).tail;
            ((LinkedNodeList)first).tail = this.previous;
            if (this == ((LinkedNodeList)first).head) {
                ((LinkedNodeList)first).head = null;
            } else {
                this.previous.next = null;
                this.previous = null;
            }
            return second;
        }

        @Override
        public NodeList<E> splitAfter() {
            Preconditions.checkState(this.list != null);
            LinkedNodeList<E> first = this.list;
            LinkedNodeList second = new LinkedNodeList();
            if (this == ((LinkedNodeList)first).tail) {
                return second;
            }
            NodeImpl<E> node = this.next;
            while (node != null) {
                node.list = second;
                second.size++;
                node = node.next;
            }
            ((LinkedNodeList)first).size -= second.size;
            ((LinkedNodeList)first).modCount++;
            second.head = this.next;
            second.tail = ((LinkedNodeList)first).tail;
            ((LinkedNodeList)first).tail = this;
            this.next.previous = null;
            this.next = null;
            return second;
        }

        @Override
        public String toString() {
            return this.element.toString();
        }
    }
}

