/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.rules;

import com.dask.sql.nodes.DaskLimit;
import com.dask.sql.nodes.DaskRel;
import com.dask.sql.nodes.DaskSort;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalSort;

public class DaskSortLimitRule
extends ConverterRule {
    public static final DaskSortLimitRule INSTANCE = ConverterRule.Config.INSTANCE.withConversion(LogicalSort.class, Convention.NONE, DaskRel.CONVENTION, "DaskSortLimitRule").withRuleFactory(DaskSortLimitRule::new).toRule(DaskSortLimitRule.class);

    DaskSortLimitRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalSort sort = (LogicalSort)rel;
        RelTraitSet traitSet = sort.getTraitSet().replace(this.out);
        RelNode transformedInput = DaskSortLimitRule.convert(sort.getInput(), sort.getInput().getTraitSet().replace(DaskRel.CONVENTION));
        if (!sort.getCollation().getFieldCollations().isEmpty()) {
            transformedInput = DaskSort.create(transformedInput.getCluster(), traitSet, transformedInput, sort.getCollation());
        }
        if (sort.fetch == null && sort.offset == null) {
            return transformedInput;
        }
        return DaskLimit.create(sort.getCluster(), traitSet, transformedInput, sort.offset, sort.fetch);
    }
}

