/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.application;

import com.dask.sql.application.DaskPlanner;
import com.dask.sql.application.DaskProgram;
import com.dask.sql.application.DaskSqlDialect;
import com.dask.sql.application.DaskSqlParser;
import com.dask.sql.application.DaskSqlToRelConverter;
import com.dask.sql.schema.DaskSchema;
import java.sql.SQLException;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;

public class RelationalAlgebraGenerator {
    private final DaskPlanner planner = new DaskPlanner();
    private final DaskSqlToRelConverter sqlToRelConverter;
    private final DaskProgram program;
    private final DaskSqlParser parser;

    public RelationalAlgebraGenerator(String rootSchemaName, List<DaskSchema> schemas, boolean case_sensitive) throws SQLException {
        this.sqlToRelConverter = new DaskSqlToRelConverter(this.planner, rootSchemaName, schemas, case_sensitive);
        this.program = new DaskProgram(this.planner);
        this.parser = new DaskSqlParser();
    }

    public static SqlDialect getDialect() {
        return DaskSqlDialect.DEFAULT;
    }

    public SqlNode getSqlNode(String sql) throws SqlParseException, ValidationException {
        SqlNode sqlNode = this.parser.parse(sql);
        return sqlNode;
    }

    public RelNode getRelationalAlgebra(SqlNode sqlNode) throws RelConversionException {
        return this.sqlToRelConverter.convert(sqlNode);
    }

    public RelNode getOptimizedRelationalAlgebra(RelNode rel) {
        return this.program.run(rel);
    }

    public String getRelationalAlgebraString(RelNode relNode) {
        return RelOptUtil.toString(relNode, SqlExplainLevel.ALL_ATTRIBUTES);
    }
}

