/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.application;

import com.dask.sql.application.DaskSqlDialect;
import com.dask.sql.schema.DaskSchema;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;

public class DaskSqlToRelConverter {
    private final SqlToRelConverter sqlToRelConverter;
    private final boolean caseSensitive;

    public DaskSqlToRelConverter(RelOptPlanner optimizer, String rootSchemaName, List<DaskSchema> schemas, boolean caseSensitive) throws SQLException {
        this.caseSensitive = caseSensitive;
        SchemaPlus rootSchema = this.createRootSchema(rootSchemaName, schemas);
        JavaTypeFactoryImpl typeFactory = this.createTypeFactory();
        CalciteCatalogReader calciteCatalogReader = this.createCatalogReader(rootSchemaName, rootSchema, typeFactory, this.caseSensitive);
        SqlValidator validator = this.createValidator(typeFactory, calciteCatalogReader);
        RelOptCluster cluster = RelOptCluster.create(optimizer, new RexBuilder(typeFactory));
        SqlToRelConverter.Config config = SqlToRelConverter.config().withTrimUnusedFields(true).withExpand(true);
        this.sqlToRelConverter = new SqlToRelConverter(null, validator, (Prepare.CatalogReader)calciteCatalogReader, cluster, StandardConvertletTable.INSTANCE, config);
    }

    public RelNode convert(SqlNode sqlNode) {
        RelNode root = this.sqlToRelConverter.convertQuery(sqlNode, true, true).project(true);
        return root;
    }

    private JavaTypeFactoryImpl createTypeFactory() {
        return new JavaTypeFactoryImpl(DaskSqlDialect.DASKSQL_TYPE_SYSTEM);
    }

    private SqlValidator createValidator(JavaTypeFactoryImpl typeFactory, CalciteCatalogReader calciteCatalogReader) {
        SqlOperatorTable operatorTable = this.createOperatorTable(calciteCatalogReader);
        CalciteConnectionConfig connectionConfig = calciteCatalogReader.getConfig();
        SqlValidator.Config validatorConfig = SqlValidator.Config.DEFAULT.withLenientOperatorLookup(connectionConfig.lenientOperatorLookup()).withSqlConformance(connectionConfig.conformance()).withDefaultNullCollation(connectionConfig.defaultNullCollation()).withIdentifierExpansion(true);
        CalciteSqlValidator validator = new CalciteSqlValidator(operatorTable, calciteCatalogReader, typeFactory, validatorConfig);
        return validator;
    }

    private SchemaPlus createRootSchema(String rootSchemaName, List<DaskSchema> schemas) throws SQLException {
        CalciteConnection calciteConnection = this.createConnection(rootSchemaName);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        for (DaskSchema schema : schemas) {
            rootSchema.add(schema.getName(), schema);
        }
        return rootSchema;
    }

    private CalciteConnection createConnection(String schemaName) throws SQLException {
        Properties info = new Properties();
        info.setProperty("lex", "JAVA");
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        calciteConnection.setSchema(schemaName);
        return calciteConnection;
    }

    private CalciteCatalogReader createCatalogReader(String schemaName, SchemaPlus schemaPlus, JavaTypeFactoryImpl typeFactory, boolean caseSensitive) throws SQLException {
        CalciteSchema calciteSchema = CalciteSchema.from(schemaPlus);
        Properties props = new Properties();
        props.setProperty("defaultSchema", schemaName);
        props.setProperty("caseSensitive", String.valueOf(caseSensitive));
        ArrayList<String> defaultSchema = new ArrayList<String>();
        defaultSchema.add(schemaName);
        CalciteCatalogReader calciteCatalogReader = new CalciteCatalogReader(calciteSchema, defaultSchema, typeFactory, new CalciteConnectionConfigImpl(props));
        return calciteCatalogReader;
    }

    private SqlOperatorTable createOperatorTable(CalciteCatalogReader calciteCatalogReader) {
        ArrayList<SqlOperatorTable> sqlOperatorTables = new ArrayList<SqlOperatorTable>();
        sqlOperatorTables.add(SqlStdOperatorTable.instance());
        sqlOperatorTables.add(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(SqlLibrary.POSTGRESQL));
        sqlOperatorTables.add(calciteCatalogReader);
        SqlOperatorTable operatorTable = SqlOperatorTables.chain(sqlOperatorTables);
        return operatorTable;
    }

    static class CalciteSqlValidator
    extends SqlValidatorImpl {
        CalciteSqlValidator(SqlOperatorTable opTab, CalciteCatalogReader catalogReader, JavaTypeFactory typeFactory, SqlValidator.Config config) {
            super(opTab, catalogReader, typeFactory, config);
        }
    }
}

