/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.application;

import com.dask.sql.nodes.DaskRel;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;

public class DaskProgram {
    private final Program mainProgram;

    public DaskProgram(RelOptPlanner planner) {
        DecorrelateProgram decorrelateProgram = new DecorrelateProgram();
        TrimFieldsProgram trimProgram = new TrimFieldsProgram();
        FixedRulesProgram fixedRulesProgram = new FixedRulesProgram();
        ConvertProgram convertProgram = new ConvertProgram(planner);
        CostBasedOptimizationProgram costBasedOptimizationProgram = new CostBasedOptimizationProgram(planner);
        this.mainProgram = Programs.sequence(decorrelateProgram, trimProgram, fixedRulesProgram, convertProgram, costBasedOptimizationProgram);
    }

    public RelNode run(RelNode rel) {
        RelTraitSet desiredTraits = rel.getTraitSet().replace(DaskRel.CONVENTION).simplify();
        return this.mainProgram.run(null, rel, desiredTraits, Arrays.asList(new RelOptMaterialization[0]), Arrays.asList(new RelOptLattice[0]));
    }

    private static class CostBasedOptimizationProgram
    implements DaskProgramWrapper {
        private RelOptPlanner planner;

        public CostBasedOptimizationProgram(RelOptPlanner planner) {
            this.planner = planner;
        }

        @Override
        public RelNode run(RelNode rel, RelTraitSet requiredOutputTraits) {
            this.planner.setRoot(rel);
            RelOptPlanner planner2 = this.planner.chooseDelegate();
            RelNode optimizedRel = planner2.findBestExp();
            assert (optimizedRel != null) : "could not implement exp";
            return optimizedRel;
        }
    }

    private static class ConvertProgram
    implements DaskProgramWrapper {
        private RelOptPlanner planner;

        public ConvertProgram(RelOptPlanner planner) {
            this.planner = planner;
        }

        @Override
        public RelNode run(RelNode rel, RelTraitSet requiredOutputTraits) {
            this.planner.setRoot(rel);
            if (rel.getTraitSet().equals(requiredOutputTraits)) {
                return rel;
            }
            RelNode convertedRel = this.planner.changeTraits(rel, requiredOutputTraits);
            assert (convertedRel != null);
            return convertedRel;
        }
    }

    private static class FixedRulesProgram
    implements Program {
        private static final List<RelOptRule> RULES = Arrays.asList(CoreRules.AGGREGATE_PROJECT_PULL_UP_CONSTANTS, CoreRules.AGGREGATE_ANY_PULL_UP_CONSTANTS, CoreRules.AGGREGATE_PROJECT_MERGE, CoreRules.AGGREGATE_REDUCE_FUNCTIONS, CoreRules.AGGREGATE_MERGE, CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES_TO_JOIN, CoreRules.AGGREGATE_JOIN_REMOVE, CoreRules.PROJECT_MERGE, CoreRules.FILTER_MERGE, CoreRules.PROJECT_REMOVE, CoreRules.FILTER_REDUCE_EXPRESSIONS, CoreRules.FILTER_EXPAND_IS_NOT_DISTINCT_FROM, CoreRules.PROJECT_TO_LOGICAL_PROJECT_AND_WINDOW);

        private FixedRulesProgram() {
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            Program fixedRulesProgram = Programs.hep(RULES, true, DefaultRelMetadataProvider.INSTANCE);
            return fixedRulesProgram.run(planner, rel, requiredOutputTraits, materializations, lattices);
        }
    }

    private static class TrimFieldsProgram
    implements DaskProgramWrapper {
        private TrimFieldsProgram() {
        }

        @Override
        public RelNode run(RelNode rel, RelTraitSet relTraitSet) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            return new RelFieldTrimmer(null, relBuilder).trim(rel);
        }
    }

    private static class DecorrelateProgram
    implements DaskProgramWrapper {
        private DecorrelateProgram() {
        }

        @Override
        public RelNode run(RelNode rel, RelTraitSet relTraitSet) {
            RelBuilder relBuilder = RelFactories.LOGICAL_BUILDER.create(rel.getCluster(), null);
            return RelDecorrelator.decorrelateQuery(rel, relBuilder);
        }
    }

    private static interface DaskProgramWrapper
    extends Program {
        public RelNode run(RelNode var1, RelTraitSet var2);

        @Override
        default public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits, List<RelOptMaterialization> materializations, List<RelOptLattice> lattices) {
            return this.run(rel, requiredOutputTraits);
        }
    }
}

