/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules.materialize;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.materialize.MaterializedViewRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;

public abstract class MaterializedViewJoinRule<C extends MaterializedViewRule.Config>
extends MaterializedViewRule<C> {
    MaterializedViewJoinRule(C config) {
        super(config);
    }

    @Override
    protected boolean isValidPlan(Project topProject, RelNode node, RelMetadataQuery mq) {
        return this.isValidRelNodePlan(node, mq);
    }

    @Override
    protected MaterializedViewRule.ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, MaterializedViewRule.EquivalenceClasses queryEC, Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
        if (((MaterializedViewRule.Config)this.config).fastBailOut()) {
            for (RelNode relNode : node.getInputs()) {
                if (!mq.getTableReferences(relNode).containsAll(viewTableRefs)) continue;
                return null;
            }
        }
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
            if (viewTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        Collection<RelNode> collection = mq.getNodeTypes(node).get(TableScan.class);
        ArrayList<RelNode> newRels = new ArrayList<RelNode>();
        block2: for (RexTableInputRef.RelTableRef relTableRef : extraTableRefs) {
            int i = 0;
            for (RelNode relNode : collection) {
                if (!relTableRef.getQualifiedName().equals(relNode.getTable().getQualifiedName()) || relTableRef.getEntityNumber() != i++) continue;
                newRels.add(relNode);
                continue block2;
            }
        }
        assert (extraTableRefs.size() == newRels.size());
        relBuilder.push(input);
        for (RelNode relNode : newRels) {
            relBuilder.push(relNode);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode newView = relBuilder.build();
        relBuilder.push(topViewProject != null ? topViewProject : viewNode);
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode relNode = relBuilder.build();
        return MaterializedViewRule.ViewPartialRewriting.of(newView, null, relNode);
    }

    @Override
    protected RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> viewToQueryTableMapping, MaterializedViewRule.EquivalenceClasses viewEC, MaterializedViewRule.EquivalenceClasses queryEC) {
        RelNode newNode = node;
        RelNode target = node;
        if (((MaterializedViewRule.Config)this.config).unionRewritingPullProgram() != null) {
            HepPlanner tmpPlanner = new HepPlanner(((MaterializedViewRule.Config)this.config).unionRewritingPullProgram());
            tmpPlanner.setRoot(newNode);
            newNode = tmpPlanner.findBestExp();
            target = newNode.getInput(0);
        }
        List<RexNode> queryExprs = this.extractReferences(rexBuilder, target);
        if (!compensationColumnsEquiPred.isAlwaysTrue() && (compensationColumnsEquiPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, viewToQueryTableMapping.inverse(), queryEC, false, compensationColumnsEquiPred)) == null) {
            return null;
        }
        if (!otherCompensationPred.isAlwaysTrue() && (otherCompensationPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, viewToQueryTableMapping.inverse(), viewEC, true, otherCompensationPred)) == null) {
            return null;
        }
        RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, ImmutableList.of(compensationColumnsEquiPred, otherCompensationPred)));
        RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
        if (((MaterializedViewRule.Config)this.config).unionRewritingPullProgram() != null) {
            rewrittenPlan = newNode.copy(newNode.getTraitSet(), ImmutableList.of(rewrittenPlan));
        }
        if (topProject != null) {
            return topProject.copy(topProject.getTraitSet(), ImmutableList.of(rewrittenPlan));
        }
        return rewrittenPlan;
    }

    @Override
    protected RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
        relBuilder.push(unionInputQuery);
        relBuilder.push(unionInputView);
        relBuilder.union(true);
        ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
        ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
        for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
            RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
            exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
            nameList.add(field.getName());
        }
        relBuilder.project(exprList, nameList);
        return relBuilder.build();
    }

    @Override
    protected RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MaterializedViewRule.MatchModality matchModality, boolean unionRewriting, RelNode input, Project topProject, RelNode node, Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses queryEC) {
        List<RexNode> exprs = topProject == null ? this.extractReferences(rexBuilder, node) : topProject.getProjects();
        ArrayList<RexNode> exprsLineage = new ArrayList<RexNode>(exprs.size());
        for (RexNode expr : exprs) {
            Set<RexNode> s2 = mq.getExpressionLineage(node, expr);
            if (s2 == null) {
                return null;
            }
            assert (s2.size() == 1);
            exprsLineage.add(RexUtil.swapColumnReferences(rexBuilder, s2.iterator().next(), queryEC.getEquivalenceClassesMap()));
        }
        List<RexNode> viewExprs = topViewProject == null ? this.extractReferences(rexBuilder, viewNode) : topViewProject.getProjects();
        List<RexNode> rewrittenExprs = this.rewriteExpressions(rexBuilder, mq, input, viewNode, viewExprs, queryToViewTableMapping.inverse(), queryEC, true, exprsLineage);
        if (rewrittenExprs == null) {
            return null;
        }
        return relBuilder.push(input).project(rewrittenExprs).convert(topProject != null ? topProject.getRowType() : node.getRowType(), false).build();
    }

    @Override
    public Pair<RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, RelNode topViewProject, RelNode viewNode, RexNode cond) {
        return Pair.of(topViewProject, viewNode);
    }
}

