/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public final class LogicalWindow
extends Window {
    public LogicalWindow(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traitSet, input, constants, rowType, groups);
    }

    @Override
    public LogicalWindow copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new LogicalWindow(this.getCluster(), traitSet, LogicalWindow.sole(inputs), this.constants, this.rowType, this.groups);
    }

    public static LogicalWindow create(RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        return new LogicalWindow(input.getCluster(), traitSet, input, constants, rowType, groups);
    }

    public static RelNode create(RelOptCluster cluster, RelTraitSet traitSet, RelBuilder relBuilder, RelNode child, RexProgram program) {
        RelDataType outRowType = program.getOutputRowType();
        LinkedListMultimap<WindowKey, RexOver> windowMap = LinkedListMultimap.create();
        final int inputFieldCount = child.getRowType().getFieldCount();
        final HashMap constantPool = new HashMap();
        final ArrayList<RexLiteral> constants = new ArrayList<RexLiteral>();
        RexShuttle replaceConstants = new RexShuttle(){

            @Override
            public RexNode visitLiteral(RexLiteral literal) {
                RexInputRef ref = (RexInputRef)constantPool.get(literal);
                if (ref != null) {
                    return ref;
                }
                constants.add(literal);
                ref = new RexInputRef(constantPool.size() + inputFieldCount, literal.getType());
                constantPool.put(literal, ref);
                return ref;
            }
        };
        final IdentityHashMap<Object, RexOver> origToNewOver = new IdentityHashMap<Object, RexOver>();
        for (RexNode agg : program.getExprList()) {
            if (!(agg instanceof RexOver)) continue;
            RexOver origOver = (RexOver)agg;
            RexOver rexOver = (RexOver)origOver.accept(replaceConstants);
            origToNewOver.put(origOver, rexOver);
            LogicalWindow.addWindows(windowMap, rexOver, inputFieldCount);
        }
        final HashMap<RexOver, Window.RexWinAggCall> aggMap = new HashMap<RexOver, Window.RexWinAggCall>();
        ArrayList<Window.Group> groups = new ArrayList<Window.Group>();
        for (Map.Entry entry : windowMap.asMap().entrySet()) {
            WindowKey windowKey = (WindowKey)entry.getKey();
            ArrayList<Window.RexWinAggCall> aggCalls = new ArrayList<Window.RexWinAggCall>();
            for (RexOver rexOver : (Collection)entry.getValue()) {
                Window.RexWinAggCall aggCall = new Window.RexWinAggCall(rexOver.getAggOperator(), rexOver.getType(), LogicalWindow.toInputRefs(rexOver.operands), aggMap.size(), rexOver.isDistinct(), rexOver.ignoreNulls());
                aggCalls.add(aggCall);
                aggMap.put(rexOver, aggCall);
            }
            Iterator toInputRefs = new RexShuttle(){

                @Override
                public RexNode visitLocalRef(RexLocalRef localRef) {
                    return new RexInputRef(localRef.getIndex(), localRef.getType());
                }
            };
            groups.add(new Window.Group(windowKey.groupSet, windowKey.isRows, windowKey.lowerBound.accept(toInputRefs), windowKey.upperBound.accept(toInputRefs), windowKey.orderKeys, aggCalls));
        }
        final ArrayList flattenedAggCallList = new ArrayList();
        ArrayList<RelDataTypeField> arrayList = new ArrayList<RelDataTypeField>(child.getRowType().getFieldList());
        int offset = arrayList.size();
        HashMap<Integer, String> fieldNames = new HashMap<Integer, String>();
        for (Ord ord : Ord.zip(program.getProjectList())) {
            int index = ((RexLocalRef)ord.e).getIndex();
            if (index < offset) continue;
            fieldNames.put(index - offset, outRowType.getFieldNames().get(ord.i));
        }
        for (Ord ord : Ord.zip(groups)) {
            for (Ord<Window.RexWinAggCall> over : Ord.zip(((Window.Group)ord.e).aggCalls)) {
                String name = (String)fieldNames.get(over.i);
                if (name == null || name.startsWith("$")) {
                    name = "w" + ord.i + "$o" + over.i;
                }
                arrayList.add((RelDataTypeField)((Object)Pair.of(name, ((Window.RexWinAggCall)over.e).getType())));
                flattenedAggCallList.add(over.e);
            }
        }
        final RelDataType intermediateRowType = cluster.getTypeFactory().createStructType(arrayList);
        RexShuttle rexShuttle = new RexShuttle(){

            @Override
            public RexNode visitOver(RexOver over) {
                Window.RexWinAggCall aggCall = (Window.RexWinAggCall)aggMap.get(origToNewOver.get(over));
                assert (aggCall != null);
                assert (RelOptUtil.eq("over", over.getType(), "aggCall", aggCall.getType(), Litmus.THROW));
                int aggCallIndex = flattenedAggCallList.indexOf(aggCall);
                assert (aggCallIndex >= 0);
                int index = inputFieldCount + aggCallIndex;
                assert (RelOptUtil.eq("over", over.getType(), "intermed", intermediateRowType.getFieldList().get(index).getType(), Litmus.THROW));
                return new RexInputRef(index, over.getType());
            }

            @Override
            public RexNode visitLocalRef(RexLocalRef localRef) {
                int index = localRef.getIndex();
                if (index < inputFieldCount) {
                    return localRef;
                }
                return new RexLocalRef(flattenedAggCallList.size() + index, localRef.getType());
            }
        };
        LogicalWindow window = LogicalWindow.create(traitSet, child, constants, intermediateRowType, groups);
        List<RexNode> refToWindow = LogicalWindow.toInputRefs(rexShuttle.visitList(program.getExprList()));
        ArrayList<RexInputRef> projectList = new ArrayList<RexInputRef>();
        for (RexLocalRef inputRef : program.getProjectList()) {
            int index = inputRef.getIndex();
            RexInputRef ref = (RexInputRef)refToWindow.get(index);
            projectList.add(ref);
        }
        return relBuilder.push(window).project(projectList, outRowType.getFieldNames()).build();
    }

    private static List<RexNode> toInputRefs(final List<? extends RexNode> operands) {
        return new AbstractList<RexNode>(){

            @Override
            public int size() {
                return operands.size();
            }

            @Override
            public RexNode get(int index) {
                RexNode operand = (RexNode)operands.get(index);
                if (operand instanceof RexInputRef) {
                    return operand;
                }
                assert (operand instanceof RexLocalRef);
                RexLocalRef ref = (RexLocalRef)operand;
                return new RexInputRef(ref.getIndex(), ref.getType());
            }
        };
    }

    private static void addWindows(Multimap<WindowKey, RexOver> windowMap, RexOver over, int inputFieldCount) {
        RexWindow aggWindow = over.getWindow();
        RelCollation orderKeys = LogicalWindow.getCollation(Lists.newArrayList(Util.filter(aggWindow.orderKeys, rexFieldCollation -> rexFieldCollation.left instanceof RexLocalRef)));
        ImmutableBitSet groupSet = ImmutableBitSet.of(LogicalWindow.getProjectOrdinals(aggWindow.partitionKeys));
        int groupLength = groupSet.length();
        if (inputFieldCount < groupLength) {
            groupSet = groupSet.except(ImmutableBitSet.range(inputFieldCount, groupLength));
        }
        WindowKey windowKey = new WindowKey(groupSet, orderKeys, aggWindow.isRows(), aggWindow.getLowerBound(), aggWindow.getUpperBound());
        windowMap.put(windowKey, over);
    }

    private static class WindowKey {
        private final ImmutableBitSet groupSet;
        private final RelCollation orderKeys;
        private final boolean isRows;
        private final RexWindowBound lowerBound;
        private final RexWindowBound upperBound;

        WindowKey(ImmutableBitSet groupSet, RelCollation orderKeys, boolean isRows, RexWindowBound lowerBound, RexWindowBound upperBound) {
            this.groupSet = groupSet;
            this.orderKeys = orderKeys;
            this.isRows = isRows;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public int hashCode() {
            return Objects.hash(this.groupSet, this.orderKeys, this.isRows, this.lowerBound, this.upperBound);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof WindowKey && this.groupSet.equals(((WindowKey)obj).groupSet) && this.orderKeys.equals(((WindowKey)obj).orderKeys) && Objects.equals(this.lowerBound, ((WindowKey)obj).lowerBound) && Objects.equals(this.upperBound, ((WindowKey)obj).upperBound) && this.isRows == ((WindowKey)obj).isRows;
        }
    }
}

