/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apiguardian.api.API;

public abstract class Project
extends SingleRel
implements Hintable {
    protected final ImmutableList<RexNode> exps;
    protected final ImmutableList<RelHint> hints;

    protected Project(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traits, input);
        assert (rowType != null);
        this.exps = ImmutableList.copyOf(projects);
        this.hints = ImmutableList.copyOf(hints);
        this.rowType = rowType;
        assert (this.isValid(Litmus.THROW, null));
    }

    @Deprecated
    protected Project(RelOptCluster cluster, RelTraitSet traits, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        this(cluster, traits, ImmutableList.of(), input, projects, rowType);
    }

    @Deprecated
    protected Project(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, ImmutableList.of(), input, projects, rowType);
        Util.discard(flags);
    }

    protected Project(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), ImmutableList.of(), input.getInput(), input.getExpressionList("exprs"), input.getRowType("exprs", "fields"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Project.sole(inputs), this.exps, this.rowType);
    }

    public abstract Project copy(RelTraitSet var1, RelNode var2, List<RexNode> var3, RelDataType var4);

    @Deprecated
    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
        Util.discard(flags);
        return this.copy(traitSet, input, projects, rowType);
    }

    @Deprecated
    public boolean isBoxed() {
        return true;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        List<RexNode> exps = shuttle.apply(this.exps);
        if (this.exps == exps) {
            return this;
        }
        RelDataType rowType = RexUtil.createStructType(this.getInput().getCluster().getTypeFactory(), exps, this.rowType.getFieldNames(), null);
        return this.copy(this.traitSet, this.getInput(), exps, rowType);
    }

    public List<RexNode> getProjects() {
        return this.exps;
    }

    public final List<Pair<RexNode, String>> getNamedProjects() {
        return Pair.zip(this.getProjects(), this.getRowType().getFieldNames());
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }

    @Deprecated
    public int getFlags() {
        return 1;
    }

    public final boolean containsOver() {
        return RexOver.containsOver(this.getProjects(), null);
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!super.isValid(litmus, context)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!RexUtil.compatibleTypes(this.exps, this.getRowType(), litmus)) {
            return litmus.fail("incompatible types", new Object[0]);
        }
        RexChecker checker = new RexChecker(this.getInput().getRowType(), context, litmus);
        for (RexNode exp : this.exps) {
            exp.accept(checker);
            if (checker.getFailureCount() <= 0) continue;
            return litmus.fail("{} failures in expression {}", checker.getFailureCount(), exp);
        }
        if (!Util.isDistinct(this.rowType.getFieldNames())) {
            return litmus.fail("field names not distinct: {}", this.rowType);
        }
        return litmus.succeed();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this.getInput());
        double dCpu = dRows * (double)this.exps.size();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    private static int countTrivial(List<RexNode> refs) {
        for (int i = 0; i < refs.size(); ++i) {
            RexNode ref = refs.get(i);
            if (ref instanceof RexInputRef && ((RexInputRef)ref).getIndex() == i) continue;
            return i;
        }
        return refs.size();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        if (pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES) {
            int firstNonTrivial = Project.countTrivial(this.exps);
            if (firstNonTrivial == 1) {
                pw.item("inputs", "0");
            } else if (firstNonTrivial != 0) {
                pw.item("inputs", "0.." + (firstNonTrivial - 1));
            }
            if (firstNonTrivial != this.exps.size()) {
                pw.item("exprs", this.exps.subList(firstNonTrivial, this.exps.size()));
            }
            return pw;
        }
        if (pw.nest()) {
            pw.item("fields", this.rowType.getFieldNames());
            pw.item("exprs", this.exps);
        } else {
            for (Ord<RelDataTypeField> field : Ord.zip(this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, this.exps.get(field.i));
            }
        }
        return pw;
    }

    @API(since="1.24", status=API.Status.INTERNAL)
    protected boolean deepEquals0(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Project o = (Project)obj;
        return this.traitSet.equals(o.traitSet) && this.input.deepEquals(o.input) && this.exps.equals(o.exps) && this.hints.equals(o.hints) && this.getRowType().equalsSansFieldNames(o.getRowType());
    }

    @API(since="1.24", status=API.Status.INTERNAL)
    protected int deepHashCode0() {
        return Objects.hash(this.traitSet, this.input.deepHashCode(), this.exps, this.hints);
    }

    public Mappings.TargetMapping getMapping() {
        return Project.getMapping(this.getInput().getRowType().getFieldCount(), this.exps);
    }

    public static Mappings.TargetMapping getMapping(int inputFieldCount, List<? extends RexNode> projects) {
        if (inputFieldCount < projects.size()) {
            return null;
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, inputFieldCount, projects.size());
        for (Ord<? extends RexNode> exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) {
                return null;
            }
            int source = ((RexInputRef)exp.e).getIndex();
            if (mapping.getTargetOpt(source) != -1) {
                return null;
            }
            mapping.set(source, exp.i);
        }
        return mapping;
    }

    public static Mappings.TargetMapping getPartialMapping(int inputFieldCount, List<? extends RexNode> projects) {
        Mapping mapping = Mappings.create(MappingType.INVERSE_FUNCTION, inputFieldCount, projects.size());
        for (Ord<? extends RexNode> exp : Ord.zip(projects)) {
            if (!(exp.e instanceof RexInputRef)) continue;
            mapping.set(((RexInputRef)exp.e).getIndex(), exp.i);
        }
        return mapping;
    }

    public Permutation getPermutation() {
        return Project.getPermutation(this.getInput().getRowType().getFieldCount(), this.exps);
    }

    public static Permutation getPermutation(int inputFieldCount, List<? extends RexNode> projects) {
        int fieldCount = projects.size();
        if (fieldCount != inputFieldCount) {
            return null;
        }
        Permutation permutation = new Permutation(fieldCount);
        HashSet<Integer> alreadyProjected = new HashSet<Integer>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            int index;
            RexNode exp = projects.get(i);
            if (exp instanceof RexInputRef) {
                index = ((RexInputRef)exp).getIndex();
                if (!alreadyProjected.add(index)) {
                    return null;
                }
            } else {
                return null;
            }
            permutation.set(i, index);
        }
        return permutation;
    }

    public boolean isMapping() {
        for (RexNode exp : this.exps) {
            if (exp instanceof RexInputRef) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static class Flags {
        public static final int ANON_FIELDS = 2;
        public static final int BOXED = 1;
        public static final int NONE = 0;
    }
}

