/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.profile;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.yahoo.sketches.hll.HllSketch;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.profile.Profiler;
import org.apache.calcite.profile.SimpleProfiler;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.PartiallyOrderedSet;
import org.apache.calcite.util.Util;

public class ProfilerImpl
implements Profiler {
    private final int combinationsPerPass;
    private final int interestingCount;
    private final Predicate<Pair<Space, Profiler.Column>> predicate;

    public static Builder builder() {
        return new Builder();
    }

    ProfilerImpl(int combinationsPerPass, int interestingCount, Predicate<Pair<Space, Profiler.Column>> predicate) {
        Preconditions.checkArgument(combinationsPerPass > 2);
        Preconditions.checkArgument(interestingCount > 2);
        this.combinationsPerPass = combinationsPerPass;
        this.interestingCount = interestingCount;
        this.predicate = predicate;
    }

    @Override
    public Profiler.Profile profile(Iterable<List<Comparable>> rows, List<Profiler.Column> columns, Collection<ImmutableBitSet> initialGroups) {
        return new Run(columns, initialGroups).profile(rows);
    }

    static class SurpriseQueue {
        private final int warmUpCount;
        private final int size;
        int count = 0;
        final Deque<Double> deque = new ArrayDeque<Double>();
        final PriorityQueue<Double> priorityQueue = new PriorityQueue(11, Ordering.natural());

        SurpriseQueue(int warmUpCount, int size) {
            this.warmUpCount = warmUpCount;
            this.size = size;
            Preconditions.checkArgument(warmUpCount > 3);
            Preconditions.checkArgument(size > 0);
        }

        public String toString() {
            return "min: " + this.priorityQueue.peek() + ", contents: " + this.deque.toString();
        }

        boolean isValid() {
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                System.out.println(this.toString());
            }
            assert (this.deque.size() == this.priorityQueue.size());
            if (this.count > this.size) assert (this.deque.size() == this.size);
            return true;
        }

        boolean offer(double d) {
            boolean b;
            if (this.count++ < this.warmUpCount || d > this.priorityQueue.peek()) {
                if (this.priorityQueue.size() >= this.size) {
                    this.priorityQueue.remove(this.deque.pop());
                }
                this.priorityQueue.add(d);
                this.deque.add(d);
                b = true;
            } else {
                b = false;
            }
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                System.out.println("offer " + d + " min " + this.priorityQueue.peek() + " accepted " + b);
            }
            return b;
        }
    }

    static class HllCompositeCollector
    extends HllCollector {
        private final int[] columnOrdinals;
        private final ByteBuffer buf = ByteBuffer.allocate(1024);

        HllCompositeCollector(Space space, int[] columnOrdinals) {
            super(space);
            this.columnOrdinals = columnOrdinals;
        }

        @Override
        public void add(List<Comparable> row) {
            if (this.space.columnOrdinals.equals(CompositeCollector.OF)) {
                Util.discard(0);
            }
            int nullCountThisRow = 0;
            this.buf.clear();
            for (int columnOrdinal : this.columnOrdinals) {
                Comparable value = row.get(columnOrdinal);
                if (value == NullSentinel.INSTANCE) {
                    if (nullCountThisRow++ == 0) {
                        ++this.nullCount;
                    }
                    this.buf.put((byte)0);
                    continue;
                }
                if (value instanceof String) {
                    this.buf.put((byte)1).put(((String)((Object)value)).getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                if (value instanceof Double) {
                    this.buf.put((byte)2).putDouble((Double)value);
                    continue;
                }
                if (value instanceof Float) {
                    this.buf.put((byte)3).putFloat(((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Long) {
                    this.buf.put((byte)4).putLong((Long)value);
                    continue;
                }
                if (value instanceof Integer) {
                    this.buf.put((byte)5).putInt((Integer)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    this.buf.put((Boolean)value != false ? (byte)6 : 7);
                    continue;
                }
                this.buf.put((byte)8).put(value.toString().getBytes(StandardCharsets.UTF_8));
            }
            this.sketch.update(Arrays.copyOf(this.buf.array(), this.buf.position()));
        }
    }

    static class HllSingletonCollector
    extends HllCollector {
        final int columnOrdinal;

        HllSingletonCollector(Space space, int columnOrdinal) {
            super(space);
            this.columnOrdinal = columnOrdinal;
        }

        @Override
        public void add(List<Comparable> row) {
            Comparable value = row.get(this.columnOrdinal);
            if (value == NullSentinel.INSTANCE) {
                ++this.nullCount;
                this.sketch.update(NULL_BITS);
            } else {
                this.add(value);
            }
        }
    }

    static abstract class HllCollector
    extends Collector {
        final HllSketch sketch = HllSketch.builder().build();
        int nullCount = 0;
        static final long[] NULL_BITS = new long[]{-6955856359840122346L};

        HllCollector(Space space) {
            super(space);
        }

        protected void add(Comparable value) {
            if (value == NullSentinel.INSTANCE) {
                this.sketch.update(NULL_BITS);
            } else if (value instanceof String) {
                this.sketch.update((String)((Object)value));
            } else if (value instanceof Double) {
                this.sketch.update((Double)value);
            } else if (value instanceof Float) {
                this.sketch.update(((Float)value).floatValue());
            } else if (value instanceof Long) {
                this.sketch.update((Long)value);
            } else if (value instanceof Number) {
                this.sketch.update(((Number)((Object)value)).longValue());
            } else {
                this.sketch.update(value.toString());
            }
        }

        @Override
        public void finish() {
            this.space.nullCount = this.nullCount;
            this.space.cardinality = (int)this.sketch.getEstimate();
            this.space.valueSet = null;
        }
    }

    static class CompositeCollector
    extends Collector {
        protected static final ImmutableBitSet OF = ImmutableBitSet.of(2, 13);
        final Set<FlatLists.ComparableList> values = new HashSet<FlatLists.ComparableList>();
        final int[] columnOrdinals;
        final Comparable[] columnValues;
        int nullCount = 0;
        private final int sketchThreshold;

        CompositeCollector(Space space, int[] columnOrdinals, int sketchThreshold) {
            super(space);
            this.columnOrdinals = columnOrdinals;
            this.columnValues = new Comparable[columnOrdinals.length];
            this.sketchThreshold = sketchThreshold;
        }

        @Override
        public void add(List<Comparable> row) {
            if (this.space.columnOrdinals.equals(OF)) {
                Util.discard(0);
            }
            int nullCountThisRow = 0;
            int length = this.columnOrdinals.length;
            for (int i = 0; i < length; ++i) {
                Comparable value = row.get(this.columnOrdinals[i]);
                if (value == NullSentinel.INSTANCE && nullCountThisRow++ == 0) {
                    ++this.nullCount;
                }
                this.columnValues[i] = value;
            }
            if (this.values.add((FlatLists.ComparableList)FlatLists.copyOf((Comparable[])this.columnValues)) && this.values.size() == this.sketchThreshold) {
                HllCompositeCollector collector = new HllCompositeCollector(this.space, this.columnOrdinals);
                ArrayList<Object> list = new ArrayList<Object>(Collections.nCopies(this.columnOrdinals[this.columnOrdinals.length - 1] + 1, null));
                for (FlatLists.ComparableList value : this.values) {
                    for (int i = 0; i < value.size(); ++i) {
                        Comparable c = (Comparable)value.get(i);
                        list.set(this.columnOrdinals[i], c);
                    }
                    collector.add(list);
                }
                this.space.collector = collector;
            }
        }

        @Override
        public void finish() {
            this.space.nullCount = this.nullCount;
            this.space.cardinality = this.values.size() + (this.nullCount > 0 ? 1 : 0);
            this.space.valueSet = null;
        }
    }

    static class SingletonCollector
    extends Collector {
        final SortedSet<Comparable> values = new TreeSet<Comparable>();
        final int columnOrdinal;
        final int sketchThreshold;
        int nullCount = 0;

        SingletonCollector(Space space, int columnOrdinal, int sketchThreshold) {
            super(space);
            this.columnOrdinal = columnOrdinal;
            this.sketchThreshold = sketchThreshold;
        }

        @Override
        public void add(List<Comparable> row) {
            Comparable v = row.get(this.columnOrdinal);
            if (v == NullSentinel.INSTANCE) {
                ++this.nullCount;
            } else if (this.values.add(v) && this.values.size() == this.sketchThreshold) {
                HllSingletonCollector collector = new HllSingletonCollector(this.space, this.columnOrdinal);
                for (Comparable value : this.values) {
                    collector.add(value);
                }
                this.space.collector = collector;
            }
        }

        @Override
        public void finish() {
            this.space.nullCount = this.nullCount;
            this.space.cardinality = this.values.size() + (this.nullCount > 0 ? 1 : 0);
            this.space.valueSet = this.values.size() < 20 ? this.values : null;
        }
    }

    static abstract class Collector {
        protected final Space space;

        Collector(Space space) {
            this.space = space;
        }

        abstract void add(List<Comparable> var1);

        abstract void finish();

        public static Collector create(Space space, int sketchThreshold) {
            List<Integer> columnOrdinalList = space.columnOrdinals.asList();
            if (columnOrdinalList.size() == 1) {
                return new SingletonCollector(space, columnOrdinalList.get(0), sketchThreshold);
            }
            return new CompositeCollector(space, (int[])Primitive.INT.toArray(columnOrdinalList), sketchThreshold);
        }
    }

    public static class Builder {
        int combinationsPerPass = 100;
        Predicate<Pair<Space, Profiler.Column>> predicate = p -> true;

        public ProfilerImpl build() {
            return new ProfilerImpl(this.combinationsPerPass, 200, this.predicate);
        }

        public Builder withPassSize(int passSize) {
            this.combinationsPerPass = passSize;
            return this;
        }

        public Builder withMinimumSurprise(double v) {
            this.predicate = spaceColumnPair -> {
                Space space = (Space)spaceColumnPair.left;
                return false;
            };
            return this;
        }
    }

    static class Space {
        private final Run run;
        final ImmutableBitSet columnOrdinals;
        final ImmutableSortedSet<Profiler.Column> columns;
        boolean unique;
        final BitSet dependencies = new BitSet();
        final Set<ImmutableBitSet> dependents = new HashSet<ImmutableBitSet>();
        double expectedCardinality;
        Collector collector;
        int nullCount;
        int cardinality;
        SortedSet<Comparable> valueSet;

        Space(Run run, ImmutableBitSet columnOrdinals, Iterable<Profiler.Column> columns) {
            this.run = run;
            this.columnOrdinals = columnOrdinals;
            this.columns = ImmutableSortedSet.copyOf(columns);
        }

        public int hashCode() {
            return this.columnOrdinals.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Space && this.columnOrdinals.equals(((Space)o).columnOrdinals);
        }

        public Profiler.Distribution distribution() {
            return this.run.distributions.get(this.columnOrdinals);
        }

        double surprise() {
            return SimpleProfiler.surprise(this.expectedCardinality, this.cardinality);
        }
    }

    class Run {
        private final List<Profiler.Column> columns;
        final PartiallyOrderedSet<ImmutableBitSet> keyPoset = new PartiallyOrderedSet<ImmutableBitSet>(PartiallyOrderedSet.BIT_SET_INCLUSION_ORDERING);
        final Map<ImmutableBitSet, Profiler.Distribution> distributions = new HashMap<ImmutableBitSet, Profiler.Distribution>();
        final List<Space> singletonSpaces;
        final Queue<Space> doneQueue = new PriorityQueue<Space>(100, (s0, s1) -> {
            int c = Integer.compare(s0.columns.size(), s1.columns.size());
            if (c == 0) {
                c = Double.compare(s0.surprise(), s1.surprise());
            }
            return c;
        });
        final SurpriseQueue surprises;
        final Deque<ImmutableBitSet> spaceQueue = new ArrayDeque<ImmutableBitSet>();
        final List<Profiler.Unique> uniques = new ArrayList<Profiler.Unique>();
        final List<Profiler.FunctionalDependency> functionalDependencies = new ArrayList<Profiler.FunctionalDependency>();
        final Set<ImmutableBitSet> resultSet = new HashSet<ImmutableBitSet>();
        final PartiallyOrderedSet<Space> results = new PartiallyOrderedSet<Space>((e1, e2) -> e2.columnOrdinals.contains(e1.columnOrdinals));
        private final List<ImmutableBitSet> keyOrdinalLists = new ArrayList<ImmutableBitSet>();
        private int rowCount;

        Run(List<Profiler.Column> columns, Collection<ImmutableBitSet> initialGroups) {
            this.columns = ImmutableList.copyOf(columns);
            for (Ord<Profiler.Column> ord : Ord.zip(columns)) {
                if (((Profiler.Column)ord.e).ordinal == ord.i) continue;
                throw new IllegalArgumentException();
            }
            this.singletonSpaces = new ArrayList<Space>(Collections.nCopies(columns.size(), null));
            if ((double)ProfilerImpl.this.combinationsPerPass > Math.pow(2.0, columns.size())) {
                for (ImmutableBitSet immutableBitSet : ImmutableBitSet.range(columns.size()).powerSet()) {
                    this.spaceQueue.add(immutableBitSet);
                }
            } else {
                this.spaceQueue.add(ImmutableBitSet.of());
                this.spaceQueue.addAll(initialGroups);
                if (columns.size() < ProfilerImpl.this.combinationsPerPass) {
                    for (Profiler.Column column : columns) {
                        this.spaceQueue.add(ImmutableBitSet.of(column.ordinal));
                    }
                }
            }
            this.surprises = new SurpriseQueue(1 + columns.size() + initialGroups.size(), ProfilerImpl.this.interestingCount);
        }

        Profiler.Profile profile(Iterable<List<Comparable>> rows) {
            List<Space> spaces;
            int pass = 0;
            while (!(spaces = this.nextBatch(pass)).isEmpty()) {
                this.pass(pass++, spaces, rows);
            }
            for (Space s2 : this.singletonSpaces) {
                for (ImmutableBitSet dependent : s2.dependents) {
                    this.functionalDependencies.add(new Profiler.FunctionalDependency(this.toColumns(dependent), Iterables.getOnlyElement(s2.columns)));
                }
            }
            return new Profiler.Profile(this.columns, new Profiler.RowCount(this.rowCount), this.functionalDependencies, this.distributions.values(), this.uniques);
        }

        List<Space> nextBatch(int pass) {
            ArrayList<Space> spaces = new ArrayList<Space>();
            while (spaces.size() < ProfilerImpl.this.combinationsPerPass) {
                ImmutableBitSet ordinals = this.spaceQueue.poll();
                if (ordinals != null) {
                    Space space = new Space(this, ordinals, this.toColumns(ordinals));
                    spaces.add(space);
                    if (ordinals.cardinality() != 1) continue;
                    this.singletonSpaces.set(ordinals.nth(0), space);
                    continue;
                }
                while (true) {
                    Space doneSpace;
                    if ((doneSpace = this.doneQueue.poll()) == null) {
                        return spaces;
                    }
                    if (doneSpace.columnOrdinals.cardinality() > 4) continue;
                    for (Profiler.Column column : this.columns) {
                        ImmutableBitSet nextOrdinals;
                        if (doneSpace.columnOrdinals.get(column.ordinal) || pass != 0 && doneSpace.columnOrdinals.cardinality() != 0 && (this.containsKey(doneSpace.columnOrdinals.set(column.ordinal)) || !ProfilerImpl.this.predicate.test(Pair.of(doneSpace, column))) || !this.resultSet.add(nextOrdinals = doneSpace.columnOrdinals.set(column.ordinal))) continue;
                        this.spaceQueue.add(nextOrdinals);
                    }
                    if (!this.spaceQueue.isEmpty()) break;
                }
            }
            return spaces;
        }

        private boolean containsKey(ImmutableBitSet ordinals) {
            for (ImmutableBitSet keyOrdinals : this.keyOrdinalLists) {
                if (!ordinals.contains(keyOrdinals)) continue;
                return true;
            }
            return false;
        }

        void pass(int pass, List<Space> spaces, Iterable<List<Comparable>> rows) {
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                System.out.println("pass: " + pass + ", spaces.size: " + spaces.size() + ", distributions.size: " + this.distributions.size());
            }
            for (Space space : spaces) {
                space.collector = Collector.create(space, 1000);
            }
            int rowCount = 0;
            for (List<Comparable> row : rows) {
                ++rowCount;
                for (Space space : spaces) {
                    space.collector.add(row);
                }
            }
            for (Space space : spaces) {
                space.collector.finish();
                space.collector = null;
                int nonMinimal = 0;
                block4: for (Space s2 : this.results.getDescendants(space)) {
                    Space s1;
                    if (s2.cardinality != space.cardinality) continue;
                    ImmutableBitSet dependents = space.columnOrdinals.except(s2.columnOrdinals);
                    for (int i : s2.columnOrdinals) {
                        s1 = this.singletonSpaces.get(i);
                        ImmutableBitSet rest = s2.columnOrdinals.clear(i);
                        for (ImmutableBitSet dependent : s1.dependents) {
                            if (!rest.contains(dependent)) continue;
                            ++nonMinimal;
                            continue block4;
                        }
                    }
                    for (int dependent : dependents) {
                        s1 = this.singletonSpaces.get(dependent);
                        for (ImmutableBitSet d : s1.dependents) {
                            if (!s2.columnOrdinals.contains(d)) continue;
                            ++nonMinimal;
                            continue block4;
                        }
                    }
                    space.dependencies.or(dependents.toBitSet());
                    for (int d : dependents) {
                        this.singletonSpaces.get((int)d).dependents.add(s2.columnOrdinals);
                    }
                }
                if (nonMinimal > 0) continue;
                String string = space.columns.toString();
                Util.discard(string);
                double expectedCardinality = this.expectedCardinality(rowCount, space.columnOrdinals);
                boolean minimal = nonMinimal == 0 && !space.unique && !this.containsKey(space.columnOrdinals);
                space.expectedCardinality = expectedCardinality;
                if (minimal) {
                    Profiler.Distribution distribution = new Profiler.Distribution(space.columns, space.valueSet, space.cardinality, space.nullCount, expectedCardinality, minimal);
                    double surprise = distribution.surprise();
                    if (CalciteSystemProperty.DEBUG.value().booleanValue() && surprise > 0.1) {
                        System.out.println(distribution.columnOrdinals() + " " + distribution.columns + ", cardinality: " + distribution.cardinality + ", expected: " + distribution.expectedCardinality + ", surprise: " + distribution.surprise());
                    }
                    if (this.surprises.offer(surprise)) {
                        this.distributions.put(space.columnOrdinals, distribution);
                        this.keyPoset.add(space.columnOrdinals);
                        this.doneQueue.add(space);
                    }
                }
                if (space.cardinality != rowCount) continue;
                this.uniques.add(new Profiler.Unique(space.columns));
                this.keyOrdinalLists.add(space.columnOrdinals);
                space.unique = true;
            }
            if (pass == 0) {
                this.rowCount = rowCount;
            }
        }

        private double cardinality(double rowCount, ImmutableBitSet columns) {
            Profiler.Distribution distribution = this.distributions.get(columns);
            if (distribution != null) {
                return distribution.cardinality;
            }
            return this.expectedCardinality(rowCount, columns);
        }

        private double expectedCardinality(double rowCount, ImmutableBitSet columns) {
            Profiler.Distribution d1;
            switch (columns.cardinality()) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    return rowCount;
                }
            }
            double c = rowCount;
            for (ImmutableBitSet bitSet : this.keyPoset.getParents(columns, true)) {
                if (bitSet.isEmpty()) continue;
                d1 = this.distributions.get(bitSet);
                double c2 = this.cardinality(rowCount, columns.except(bitSet));
                double d = Lattice.getRowCount(rowCount, d1.cardinality, c2);
                c = Math.min(c, d);
            }
            for (ImmutableBitSet bitSet : this.keyPoset.getChildren(columns, true)) {
                d1 = this.distributions.get(bitSet);
                c = Math.min(c, d1.cardinality);
            }
            return c;
        }

        private ImmutableSortedSet<Profiler.Column> toColumns(Iterable<Integer> ordinals) {
            return ImmutableSortedSet.copyOf(Util.transform(ordinals, this.columns::get));
        }
    }
}

