/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.Typed;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.trace.CalciteTimingTracer;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public abstract class Prepare {
    protected static final Logger LOGGER = CalciteTrace.getStatementTracer();
    protected final CalcitePrepare.Context context;
    protected final CatalogReader catalogReader;
    protected final Convention resultConvention;
    protected CalciteTimingTracer timingTracer;
    protected List<List<String>> fieldOrigins;
    protected RelDataType parameterRowType;
    public static final TryThreadLocal<Boolean> THREAD_TRIM = TryThreadLocal.of(false);
    public static final TryThreadLocal<Boolean> THREAD_EXPAND = TryThreadLocal.of(false);

    public Prepare(CalcitePrepare.Context context, CatalogReader catalogReader, Convention resultConvention) {
        assert (context != null);
        this.context = context;
        this.catalogReader = catalogReader;
        this.resultConvention = resultConvention;
    }

    protected abstract PreparedResult createPreparedExplanation(RelDataType var1, RelDataType var2, RelRoot var3, SqlExplainFormat var4, SqlExplainLevel var5);

    protected RelRoot optimize(RelRoot root, List<Materialization> materializations, List<CalciteSchema.LatticeEntry> lattices) {
        RelOptPlanner planner = root.rel.getCluster().getPlanner();
        DataContext dataContext = this.context.getDataContext();
        planner.setExecutor(new RexExecutorImpl(dataContext));
        ArrayList<RelOptMaterialization> materializationList = new ArrayList<RelOptMaterialization>(materializations.size());
        for (Materialization materialization : materializations) {
            List<String> qualifiedTableName = materialization.materializedTable.path();
            materializationList.add(new RelOptMaterialization(materialization.tableRel, materialization.queryRel, materialization.starRelOptTable, qualifiedTableName));
        }
        ArrayList<RelOptLattice> latticeList = new ArrayList<RelOptLattice>(lattices.size());
        for (CalciteSchema.LatticeEntry lattice : lattices) {
            CalciteSchema.TableEntry starTable = lattice.getStarTable();
            JavaTypeFactory typeFactory = this.context.getTypeFactory();
            RelOptTableImpl starRelOptTable = RelOptTableImpl.create((RelOptSchema)this.catalogReader, starTable.getTable().getRowType(typeFactory), starTable, null);
            latticeList.add(new RelOptLattice(lattice.getLattice(), starRelOptTable));
        }
        RelTraitSet relTraitSet = this.getDesiredRootTraitSet(root);
        Program program = this.getProgram();
        RelNode rootRel4 = program.run(planner, root.rel, relTraitSet, materializationList, latticeList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Plan after physical tweaks: {}", (Object)RelOptUtil.toString(rootRel4, SqlExplainLevel.ALL_ATTRIBUTES));
        }
        return root.withRel(rootRel4);
    }

    protected Program getProgram() {
        Holder<Object> holder = Holder.of(null);
        Hook.PROGRAM.run(holder);
        if (holder.get() != null) {
            return holder.get();
        }
        return Programs.standard();
    }

    protected RelTraitSet getDesiredRootTraitSet(RelRoot root) {
        return root.rel.getTraitSet().replace(this.resultConvention).replace(root.collation).simplify();
    }

    protected abstract PreparedResult implement(RelRoot var1);

    public PreparedResult prepareSql(SqlNode sqlQuery, Class runtimeContextClass, SqlValidator validator, boolean needsValidation) {
        return this.prepareSql(sqlQuery, sqlQuery, runtimeContextClass, validator, needsValidation);
    }

    public PreparedResult prepareSql(SqlNode sqlQuery, SqlNode sqlNodeOriginal, Class runtimeContextClass, SqlValidator validator, boolean needsValidation) {
        this.init(runtimeContextClass);
        SqlToRelConverter.Config config = SqlToRelConverter.config().withTrimUnusedFields(true).withExpand((Boolean)THREAD_EXPAND.get()).withExplain(sqlQuery.getKind() == SqlKind.EXPLAIN);
        SqlToRelConverter sqlToRelConverter = this.getSqlToRelConverter(validator, this.catalogReader, config);
        SqlExplain sqlExplain = null;
        if (sqlQuery.getKind() == SqlKind.EXPLAIN) {
            sqlExplain = (SqlExplain)sqlQuery;
            sqlQuery = sqlExplain.getExplicandum();
            sqlToRelConverter.setDynamicParamCountInExplain(sqlExplain.getDynamicParamCount());
        }
        RelRoot root = sqlToRelConverter.convertQuery(sqlQuery, needsValidation, true);
        Hook.CONVERTED.run(root.rel);
        if (this.timingTracer != null) {
            this.timingTracer.traceTime("end sql2rel");
        }
        RelDataType resultType = validator.getValidatedNodeType(sqlQuery);
        this.fieldOrigins = validator.getFieldOrigins(sqlQuery);
        assert (this.fieldOrigins.size() == resultType.getFieldCount());
        this.parameterRowType = validator.getParameterRowType(sqlQuery);
        if (sqlExplain != null) {
            SqlExplain.Depth explainDepth = sqlExplain.getDepth();
            SqlExplainFormat format = sqlExplain.getFormat();
            SqlExplainLevel detailLevel = sqlExplain.getDetailLevel();
            switch (explainDepth) {
                case TYPE: {
                    return this.createPreparedExplanation(resultType, this.parameterRowType, null, format, detailLevel);
                }
                case LOGICAL: {
                    return this.createPreparedExplanation(null, this.parameterRowType, root, format, detailLevel);
                }
            }
        }
        root = root.withRel(this.flattenTypes(root.rel, true));
        if (this.context.config().forceDecorrelate()) {
            root = root.withRel(this.decorrelate(sqlToRelConverter, sqlQuery, root.rel));
        }
        root = this.trimUnusedFields(root);
        Hook.TRIMMED.run(root.rel);
        if (sqlExplain != null) {
            switch (sqlExplain.getDepth()) {
                default: 
            }
            root = this.optimize(root, this.getMaterializations(), this.getLattices());
            return this.createPreparedExplanation(null, this.parameterRowType, root, sqlExplain.getFormat(), sqlExplain.getDetailLevel());
        }
        root = this.optimize(root, this.getMaterializations(), this.getLattices());
        if (this.timingTracer != null) {
            this.timingTracer.traceTime("end optimization");
        }
        if (!root.kind.belongsTo(SqlKind.DML)) {
            root = root.withKind(sqlNodeOriginal.getKind());
        }
        return this.implement(root);
    }

    protected TableModify.Operation mapTableModOp(boolean isDml, SqlKind sqlKind) {
        if (!isDml) {
            return null;
        }
        switch (sqlKind) {
            case INSERT: {
                return TableModify.Operation.INSERT;
            }
            case DELETE: {
                return TableModify.Operation.DELETE;
            }
            case MERGE: {
                return TableModify.Operation.MERGE;
            }
            case UPDATE: {
                return TableModify.Operation.UPDATE;
            }
        }
        return null;
    }

    protected abstract SqlToRelConverter getSqlToRelConverter(SqlValidator var1, CatalogReader var2, SqlToRelConverter.Config var3);

    public abstract RelNode flattenTypes(RelNode var1, boolean var2);

    protected abstract RelNode decorrelate(SqlToRelConverter var1, SqlNode var2, RelNode var3);

    protected abstract List<Materialization> getMaterializations();

    protected abstract List<CalciteSchema.LatticeEntry> getLattices();

    protected RelRoot trimUnusedFields(RelRoot root) {
        SqlToRelConverter.Config config = SqlToRelConverter.config().withTrimUnusedFields(this.shouldTrim(root.rel)).withExpand((Boolean)THREAD_EXPAND.get());
        SqlToRelConverter converter = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader, config);
        boolean ordered = !root.collation.getFieldCollations().isEmpty();
        boolean dml = SqlKind.DML.contains((Object)root.kind);
        return root.withRel(converter.trimUnusedFields(dml || ordered, root.rel));
    }

    private boolean shouldTrim(RelNode rootRel) {
        return (Boolean)THREAD_TRIM.get() != false || RelOptUtil.countJoins(rootRel) < 2;
    }

    protected abstract void init(Class var1);

    protected abstract SqlValidator getSqlValidator();

    public static class Materialization {
        final CalciteSchema.TableEntry materializedTable;
        final String sql;
        final List<String> viewSchemaPath;
        RelNode tableRel;
        RelNode queryRel;
        private RelOptTable starRelOptTable;

        public Materialization(CalciteSchema.TableEntry materializedTable, String sql, List<String> viewSchemaPath) {
            assert (materializedTable != null);
            assert (sql != null);
            this.materializedTable = materializedTable;
            this.sql = sql;
            this.viewSchemaPath = viewSchemaPath;
        }

        public void materialize(RelNode queryRel, RelOptTable starRelOptTable) {
            this.queryRel = queryRel;
            this.starRelOptTable = starRelOptTable;
            assert (starRelOptTable.unwrap(StarTable.class) != null);
        }
    }

    public static abstract class PreparedResultImpl
    implements PreparedResult,
    Typed {
        protected final RelNode rootRel;
        protected final RelDataType parameterRowType;
        protected final RelDataType rowType;
        protected final boolean isDml;
        protected final TableModify.Operation tableModOp;
        protected final List<List<String>> fieldOrigins;
        protected final List<RelCollation> collations;

        public PreparedResultImpl(RelDataType rowType, RelDataType parameterRowType, List<List<String>> fieldOrigins, List<RelCollation> collations, RelNode rootRel, TableModify.Operation tableModOp, boolean isDml) {
            this.rowType = Objects.requireNonNull(rowType);
            this.parameterRowType = Objects.requireNonNull(parameterRowType);
            this.fieldOrigins = Objects.requireNonNull(fieldOrigins);
            this.collations = ImmutableList.copyOf(collations);
            this.rootRel = Objects.requireNonNull(rootRel);
            this.tableModOp = tableModOp;
            this.isDml = isDml;
        }

        @Override
        public boolean isDml() {
            return this.isDml;
        }

        @Override
        public TableModify.Operation getTableModOp() {
            return this.tableModOp;
        }

        @Override
        public List<List<String>> getFieldOrigins() {
            return this.fieldOrigins;
        }

        @Override
        public RelDataType getParameterRowType() {
            return this.parameterRowType;
        }

        public RelDataType getPhysicalRowType() {
            return this.rowType;
        }

        @Override
        public abstract Type getElementType();

        public RelNode getRootRel() {
            return this.rootRel;
        }
    }

    public static interface PreparedResult {
        public String getCode();

        public boolean isDml();

        public TableModify.Operation getTableModOp();

        public List<List<String>> getFieldOrigins();

        public RelDataType getParameterRowType();

        public Bindable getBindable(Meta.CursorFactory var1);
    }

    public static abstract class PreparedExplain
    implements PreparedResult {
        private final RelDataType rowType;
        private final RelDataType parameterRowType;
        private final RelRoot root;
        private final SqlExplainFormat format;
        private final SqlExplainLevel detailLevel;

        public PreparedExplain(RelDataType rowType, RelDataType parameterRowType, RelRoot root, SqlExplainFormat format, SqlExplainLevel detailLevel) {
            this.rowType = rowType;
            this.parameterRowType = parameterRowType;
            this.root = root;
            this.format = format;
            this.detailLevel = detailLevel;
        }

        @Override
        public String getCode() {
            if (this.root == null) {
                return RelOptUtil.dumpType(this.rowType);
            }
            return RelOptUtil.dumpPlan("", this.root.rel, this.format, this.detailLevel);
        }

        @Override
        public RelDataType getParameterRowType() {
            return this.parameterRowType;
        }

        @Override
        public boolean isDml() {
            return false;
        }

        @Override
        public TableModify.Operation getTableModOp() {
            return null;
        }

        @Override
        public List<List<String>> getFieldOrigins() {
            return Collections.singletonList(Collections.nCopies(4, null));
        }
    }

    public static abstract class AbstractPreparingTable
    implements PreparingTable {
        @Override
        public boolean columnHasDefaultValue(RelDataType rowType, int ordinal, InitializerContext initializerContext) {
            InitializerExpressionFactory initializerExpressionFactory;
            Table table = this.unwrap(Table.class);
            if (table != null && table instanceof Wrapper && (initializerExpressionFactory = ((Wrapper)((Object)table)).unwrap(InitializerExpressionFactory.class)) != null) {
                return initializerExpressionFactory.newColumnDefaultValue(this, ordinal, initializerContext).getType().getSqlTypeName() != SqlTypeName.NULL;
            }
            if (ordinal >= rowType.getFieldList().size()) {
                return true;
            }
            return !rowType.getFieldList().get(ordinal).getType().isNullable();
        }

        @Override
        public final RelOptTable extend(List<RelDataTypeField> extendedFields) {
            Table table = this.unwrap(Table.class);
            List<RelDataTypeField> baseColumns = this.getRowType().getFieldList();
            List<RelDataTypeField> dedupedFields = RelOptUtil.deduplicateColumns(baseColumns, extendedFields);
            List<RelDataTypeField> dedupedExtendedFields = dedupedFields.subList(baseColumns.size(), dedupedFields.size());
            if (table instanceof ExtensibleTable) {
                Table extendedTable = ((ExtensibleTable)table).extend(dedupedExtendedFields);
                return this.extend(extendedTable);
            }
            if (table instanceof ModifiableViewTable) {
                ModifiableViewTable modifiableViewTable = (ModifiableViewTable)table;
                ModifiableViewTable extendedView = modifiableViewTable.extend(dedupedExtendedFields, this.getRelOptSchema().getTypeFactory());
                return this.extend(extendedView);
            }
            throw new RuntimeException("Cannot extend " + table);
        }

        protected abstract RelOptTable extend(Table var1);

        @Override
        public List<ColumnStrategy> getColumnStrategies() {
            return RelOptTableImpl.columnStrategies(this);
        }
    }

    public static interface PreparingTable
    extends RelOptTable,
    SqlValidatorTable {
    }

    public static interface CatalogReader
    extends RelOptSchema,
    SqlValidatorCatalogReader,
    SqlOperatorTable {
        public static final ThreadLocal<CatalogReader> THREAD_LOCAL = new ThreadLocal();

        @Override
        public PreparingTable getTableForMember(List<String> var1);

        public CatalogReader withSchemaPath(List<String> var1);

        @Override
        public PreparingTable getTable(List<String> var1);
    }
}

