/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MultiDimensionalSpec {
    private final List<Integer> bitsPerDimension;
    private final int sumBitsPerDimension;
    private final int maxBitsPerDimension;

    public MultiDimensionalSpec(List<Integer> bitsPerDimension) {
        int maxBits = 0;
        int sumBits = 0;
        for (int bitsPerDim : bitsPerDimension) {
            Preconditions.checkArgument(bitsPerDim >= 0, "The number of bits for each dimension must be non-negative.");
            if (maxBits < bitsPerDim) {
                maxBits = bitsPerDim;
            }
            Preconditions.checkArgument((sumBits += bitsPerDim) >= 0, "The sum of the all bits must fit in int");
        }
        this.bitsPerDimension = Collections.unmodifiableList(Lists.newArrayList(bitsPerDimension));
        this.maxBitsPerDimension = maxBits;
        this.sumBitsPerDimension = sumBits;
    }

    public List<Integer> getBitsPerDimension() {
        return this.bitsPerDimension;
    }

    public int sumBitsPerDimension() {
        return this.sumBitsPerDimension;
    }

    public int maxBitsPerDimension() {
        return this.maxBitsPerDimension;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

