// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#ifndef ARROW_TYPES_DATETIME_H
#define ARROW_TYPES_DATETIME_H

#include <string>

#include "arrow/type.h"

namespace arrow {

struct DateType : public DataType {
  enum class Unit : char { DAY = 0, MONTH = 1, YEAR = 2 };

  Unit unit;

  explicit DateType(Unit unit = Unit::DAY) : DataType(Type::DATE), unit(unit) {}

  DateType(const DateType& other) : DateType(other.unit) {}

  static char const* name() { return "date"; }
};

struct ARROW_EXPORT TimestampType : public DataType {
  enum class Unit : char { SECOND = 0, MILLI = 1, MICRO = 2, NANO = 3 };

  typedef int64_t c_type;
  static constexpr Type::type type_enum = Type::TIMESTAMP;

  int value_size() const override { return sizeof(int64_t); }

  Unit unit;

  explicit TimestampType(Unit unit = Unit::MILLI)
      : DataType(Type::TIMESTAMP), unit(unit) {}

  TimestampType(const TimestampType& other) : TimestampType(other.unit) {}
  virtual ~TimestampType() {}

  std::string ToString() const override { return "timestamp"; }

  static char const* name() { return "timestamp"; }
};

}  // namespace arrow

#endif  // ARROW_TYPES_DATETIME_H
