DATA = {
  "Examples": [], 
  "dist": "python-qprogedit-4.0.5-py_0", 
  "python-scripts": [], 
  "site-packages": [
    "QProgEdit/__init__.py", 
    "QProgEdit/_qcolorscheme.py", 
    "QProgEdit/_qeditor.py", 
    "QProgEdit/_qeditorcfg.py", 
    "QProgEdit/_qeditorconst.py", 
    "QProgEdit/_qeditorfind.py", 
    "QProgEdit/_qeditorprefs.py", 
    "QProgEdit/_qeditorshortcut.py", 
    "QProgEdit/_qeditorstatus.py", 
    "QProgEdit/_qlangmenu.py", 
    "QProgEdit/_qlexer.py", 
    "QProgEdit/_qlineeditfind.py", 
    "QProgEdit/_qprogedit.py", 
    "QProgEdit/_qsymboltreewidgetitem.py", 
    "QProgEdit/_qtabcornerwidget.py", 
    "QProgEdit/_qtabmanager.py", 
    "QProgEdit/_quiloader.py", 
    "QProgEdit/clean/__init__.py", 
    "QProgEdit/clean/_python.py", 
    "QProgEdit/py3compat.py", 
    "QProgEdit/pyqt5compat.py", 
    "QProgEdit/symbols/__init__.py", 
    "QProgEdit/symbols/_python.py", 
    "QProgEdit/ui/findWidget.ui", 
    "QProgEdit/ui/prefsWidget.ui", 
    "QProgEdit/validate/__init__.py", 
    "QProgEdit/validate/_python.py", 
    "python_qprogedit-4.0.5-py2.7.egg-info/PKG-INFO", 
    "python_qprogedit-4.0.5-py2.7.egg-info/SOURCES.txt", 
    "python_qprogedit-4.0.5-py2.7.egg-info/dependency_links.txt", 
    "python_qprogedit-4.0.5-py2.7.egg-info/not-zip-safe", 
    "python_qprogedit-4.0.5-py2.7.egg-info/requires.txt", 
    "python_qprogedit-4.0.5-py2.7.egg-info/top_level.txt"
  ]
}
## END DATA

"""
This is code that is added to noarch Python packages. See
conda_build/noarch_python.py.

"""
import os
import sys
import shutil
from os.path import dirname, exists, isdir, join, normpath

# Silence pyflakes. This variable is added when link.py is written by
# conda_build.noarch_python.
if False:
    DATA = None

THIS_DIR = dirname(__file__)
PREFIX = normpath(sys.prefix)
if sys.platform == 'win32':
    BIN_DIR = join(PREFIX, 'Scripts')
    SITE_PACKAGES = 'Lib/site-packages'
else:
    BIN_DIR = join(PREFIX, 'bin')
    SITE_PACKAGES = 'lib/python%s/site-packages' % sys.version[:3]

# the list of these files is going to be store in info/_files
FILES = []


def _link(src, dst):
    try:
        os.link(src, dst)
        # on Windows os.link raises AttributeError
    except (OSError, AttributeError):
        shutil.copy2(src, dst)


def _unlink(path):
    try:
        os.unlink(path)
    except OSError:
        pass


def pyc_f(f, version_info=sys.version_info):
    if version_info[0] == 2:
        return f + 'c'
    dn, fn = f.rsplit('/', 1)
    return '%s/__pycache__/%s.cpython-%d%d.pyc' % (
              dn, fn[:-3], version_info[0], version_info[1])


def link_files(src_root, dst_root, files):
    for f in files:
        src = join(THIS_DIR, src_root, f)
        dst = join(PREFIX, dst_root, f)
        dst_dir = dirname(dst)
        if not isdir(dst_dir):
            os.makedirs(dst_dir)
        if exists(dst):
            _unlink(dst)
        _link(src, dst)
        f = '%s/%s' % (dst_root, f)
        FILES.append(f)
        if f.endswith('.py'):
            FILES.append(pyc_f(f))


def create_script(fn):
    src = join(THIS_DIR, 'python-scripts', fn)
    dst = join(BIN_DIR, fn)
    if sys.platform == 'win32':
        shutil.copyfile(src, dst + '-script.py')
        FILES.append('Scripts/%s-script.py' % fn)
        shutil.copyfile(join(THIS_DIR,
                             'cli-%d.exe' % (8 * tuple.__itemsize__)),
                        dst + '.exe')
        FILES.append('Scripts/%s.exe' % fn)
    else:
        with open(src) as fi:
            data = fi.read()
        with open(dst, 'w') as fo:
            fo.write('#!%s\n' % normpath(sys.executable))
            fo.write(data)
        os.chmod(dst, 0o755)
        FILES.append('bin/%s' % fn)


def create_scripts(files):
    if not files:
        return
    if not isdir(BIN_DIR):
        os.mkdir(BIN_DIR)
    for fn in files:
        create_script(fn)


def main():
    create_scripts(DATA['python-scripts'])
    link_files('site-packages', SITE_PACKAGES, DATA['site-packages'])
    link_files('Examples', 'Examples', DATA['Examples'])

    with open(join(PREFIX, 'conda-meta',
                   '%s.files' % DATA['dist']), 'w') as fo:
        for f in FILES:
            fo.write('%s\n' % f)


if __name__ == '__main__':
    main()
