DATA = {
  "Examples": [], 
  "dist": "python-pygaze-0.6.0a25-py_0", 
  "python-scripts": [], 
  "site-packages": [
    "pygaze/__init__.py", 
    "pygaze/_display/__init__.py", 
    "pygaze/_display/basedisplay.py", 
    "pygaze/_display/osdisplay.py", 
    "pygaze/_display/psychopydisplay.py", 
    "pygaze/_display/pygamedisplay.py", 
    "pygaze/_eyetracker/__init__.py", 
    "pygaze/_eyetracker/baseeyetracker.py", 
    "pygaze/_eyetracker/eyelinkgraphics.py", 
    "pygaze/_eyetracker/iViewXAPI.py", 
    "pygaze/_eyetracker/libdumbdummy.py", 
    "pygaze/_eyetracker/libdummytracker.py", 
    "pygaze/_eyetracker/libeyelink.py", 
    "pygaze/_eyetracker/libeyetribe.py", 
    "pygaze/_eyetracker/libopengaze.py", 
    "pygaze/_eyetracker/libsmi.py", 
    "pygaze/_eyetracker/libtobii.py", 
    "pygaze/_eyetracker/libtobiiglasses.py", 
    "pygaze/_eyetracker/libtobiilegacy.py", 
    "pygaze/_eyetracker/opengaze.py", 
    "pygaze/_eyetracker/pytribe.py", 
    "pygaze/_joystick/__init__.py", 
    "pygaze/_joystick/basejoystick.py", 
    "pygaze/_joystick/pygamejoystick.py", 
    "pygaze/_keyboard/__init__.py", 
    "pygaze/_keyboard/basekeyboard.py", 
    "pygaze/_keyboard/oskeyboard.py", 
    "pygaze/_keyboard/psychopykeyboard.py", 
    "pygaze/_keyboard/pygamekeyboard.py", 
    "pygaze/_logfile/__init__.py", 
    "pygaze/_logfile/baselogfile.py", 
    "pygaze/_logfile/logfile.py", 
    "pygaze/_misc/__init__.py", 
    "pygaze/_misc/misc.py", 
    "pygaze/_mouse/__init__.py", 
    "pygaze/_mouse/basemouse.py", 
    "pygaze/_mouse/osmouse.py", 
    "pygaze/_mouse/psychopymouse.py", 
    "pygaze/_mouse/pygamemouse.py", 
    "pygaze/_screen/__init__.py", 
    "pygaze/_screen/basescreen.py", 
    "pygaze/_screen/osscreen.py", 
    "pygaze/_screen/psychopyscreen.py", 
    "pygaze/_screen/pygamescreen.py", 
    "pygaze/_sound/__init__.py", 
    "pygaze/_sound/basesound.py", 
    "pygaze/_sound/pygamesound.py", 
    "pygaze/_time/__init__.py", 
    "pygaze/_time/basetime.py", 
    "pygaze/_time/ostime.py", 
    "pygaze/_time/psychopytime.py", 
    "pygaze/_time/pygametime.py", 
    "pygaze/defaults.py", 
    "pygaze/display.py", 
    "pygaze/eyetracker.py", 
    "pygaze/joystick.py", 
    "pygaze/keyboard.py", 
    "pygaze/libgazecon.py", 
    "pygaze/libinput.py", 
    "pygaze/liblog.py", 
    "pygaze/libscreen.py", 
    "pygaze/libsound.py", 
    "pygaze/libtime.py", 
    "pygaze/logfile.py", 
    "pygaze/mouse.py", 
    "pygaze/plugins/__init__.py", 
    "pygaze/plugins/aoi.py", 
    "pygaze/plugins/frl.py", 
    "pygaze/plugins/gazecursor.py", 
    "pygaze/py3compat.py", 
    "pygaze/screen.py", 
    "pygaze/settings.py", 
    "pygaze/sound.py", 
    "pygaze/time.py", 
    "python_pygaze-0.6.0a25-py2.7.egg-info/PKG-INFO", 
    "python_pygaze-0.6.0a25-py2.7.egg-info/SOURCES.txt", 
    "python_pygaze-0.6.0a25-py2.7.egg-info/dependency_links.txt", 
    "python_pygaze-0.6.0a25-py2.7.egg-info/not-zip-safe", 
    "python_pygaze-0.6.0a25-py2.7.egg-info/top_level.txt", 
    "share/opensesame_plugins/pygaze_drift_correct/info.yaml", 
    "share/opensesame_plugins/pygaze_drift_correct/pygaze_drift_correct.py", 
    "share/opensesame_plugins/pygaze_init/info.yaml", 
    "share/opensesame_plugins/pygaze_init/pygaze_init.py", 
    "share/opensesame_plugins/pygaze_log/info.yaml", 
    "share/opensesame_plugins/pygaze_log/pygaze_log.py", 
    "share/opensesame_plugins/pygaze_start_recording/info.yaml", 
    "share/opensesame_plugins/pygaze_start_recording/pygaze_start_recording.py", 
    "share/opensesame_plugins/pygaze_stop_recording/info.yaml", 
    "share/opensesame_plugins/pygaze_stop_recording/pygaze_stop_recording.py", 
    "share/opensesame_plugins/pygaze_wait/info.yaml", 
    "share/opensesame_plugins/pygaze_wait/pygaze_wait.py"
  ]
}
## END DATA

"""
This is code that is added to noarch Python packages. See
conda_build/noarch_python.py.

"""
import os
import sys
import shutil
from os.path import dirname, exists, isdir, join, normpath

# Silence pyflakes. This variable is added when link.py is written by
# conda_build.noarch_python.
if False:
    DATA = None

THIS_DIR = dirname(__file__)
PREFIX = normpath(sys.prefix)
if sys.platform == 'win32':
    BIN_DIR = join(PREFIX, 'Scripts')
    SITE_PACKAGES = 'Lib/site-packages'
else:
    BIN_DIR = join(PREFIX, 'bin')
    SITE_PACKAGES = 'lib/python%s/site-packages' % sys.version[:3]

# the list of these files is going to be store in info/_files
FILES = []


def _link(src, dst):
    try:
        os.link(src, dst)
        # on Windows os.link raises AttributeError
    except (OSError, AttributeError):
        shutil.copy2(src, dst)


def _unlink(path):
    try:
        os.unlink(path)
    except OSError:
        pass


def pyc_f(f, version_info=sys.version_info):
    if version_info[0] == 2:
        return f + 'c'
    dn, fn = f.rsplit('/', 1)
    return '%s/__pycache__/%s.cpython-%d%d.pyc' % (
              dn, fn[:-3], version_info[0], version_info[1])


def link_files(src_root, dst_root, files):
    for f in files:
        src = join(THIS_DIR, src_root, f)
        dst = join(PREFIX, dst_root, f)
        dst_dir = dirname(dst)
        if not isdir(dst_dir):
            os.makedirs(dst_dir)
        if exists(dst):
            _unlink(dst)
        _link(src, dst)
        f = '%s/%s' % (dst_root, f)
        FILES.append(f)
        if f.endswith('.py'):
            FILES.append(pyc_f(f))


def create_script(fn):
    src = join(THIS_DIR, 'python-scripts', fn)
    dst = join(BIN_DIR, fn)
    if sys.platform == 'win32':
        shutil.copyfile(src, dst + '-script.py')
        FILES.append('Scripts/%s-script.py' % fn)
        shutil.copyfile(join(THIS_DIR,
                             'cli-%d.exe' % (8 * tuple.__itemsize__)),
                        dst + '.exe')
        FILES.append('Scripts/%s.exe' % fn)
    else:
        with open(src) as fi:
            data = fi.read()
        with open(dst, 'w') as fo:
            fo.write('#!%s\n' % normpath(sys.executable))
            fo.write(data)
        os.chmod(dst, 0o755)
        FILES.append('bin/%s' % fn)


def create_scripts(files):
    if not files:
        return
    if not isdir(BIN_DIR):
        os.mkdir(BIN_DIR)
    for fn in files:
        create_script(fn)


def main():
    create_scripts(DATA['python-scripts'])
    link_files('site-packages', SITE_PACKAGES, DATA['site-packages'])
    link_files('Examples', 'Examples', DATA['Examples'])

    with open(join(PREFIX, 'conda-meta',
                   '%s.files' % DATA['dist']), 'w') as fo:
        for f in FILES:
            fo.write('%s\n' % f)


if __name__ == '__main__':
    main()
