"""Initializes and calibrates the eye tracker"""

category = 'PyGaze'
priority = 10
help = 'manual/eyetracking/pygaze'
icon = 'os-pygaze_init'
controls = [
  {'type': 'combobox',
   'var': 'tracker_type',
   'label': 'Select tracker type',
   'options': ['Simple dummy',
    'Advanced dummy (mouse simulation)',
    'EyeLink',
    'EyeLogic',
    'SMI',
    'EyeTribe',
    'OpenGaze',
    'Alea',
    'Tobii',
    'Tobii-legacy',
    'Tobii Pro Glasses 2'],
   'tooltip': 'A list of supported eye trackers'},
  {'type': 'checkbox',
   'var': 'calibrate',
   'label': 'Calibrate tracker',
   'tooltip': 'Indicates whether calibration should be started'},
  {'type': 'checkbox',
   'var': 'calbeep',
   'label': 'Calibration beep',
   'tooltip': 'Play a beep when the calibration target jumps',
   'name': 'checkbox_calbeep'},
  {'type': 'line_edit',
   'label': 'Log file',
   'var': '_logfile',
   'tooltip': 'The name for the log file'},
  {'type': 'spinbox',
   'var': 'sacc_vel_thr',
   'label': 'Saccade velocity threshold',
   'min_val': 0,
   'max_val': 100000,
   'suffix': ' °/s',
   'tooltip': 'Velocity threshold for saccade detection algorithm',
   'name': 'spinbox_sacc_vel_thr'},
  {'type': 'spinbox',
   'var': 'sacc_acc_thr',
   'label': 'Saccade acceleration threshold',
   'min_val': 0,
   'max_val': 100000,
   'suffix': ' °/s/s',
   'tooltip': 'Acceleration threshold for saccade detection algorithm',
   'name': 'spinbox_sacc_acc_thr'},
  {'type': 'text',
   'label': '<b>Warning:</b> PyLink is required for EyeLink functionality and is not installed. Visit http://osdoc.cogsci.nl/manual/eyetracking/eyelink/ for more information.',
   'name': 'text_eyelink_pylink_check'},
  {'type': 'text', 'label': 'DUMMY', 'name': 'text_pygaze_version'},
  {'type': 'line_edit',
   'label': 'Alea API key',
   'var': 'alea_api_key',
   'name': 'line_edit_alea_api_key',
   'tooltip': 'The API key provided to you by Alea'},
  {'type': 'checkbox',
   'var': 'alea_animated_calibration',
   'label': 'Animated calibration target',
   'tooltip': 'Turn on child-friendly animated calibration targets',
   'name': 'checkbox_alea_animated_calibration'},
  {'type': 'checkbox',
   'var': 'eyelink_force_drift_correct',
   'label': 'Force drift correction (for EyeLink 1000)',
   'tooltip': 'Turn on active drift correction',
   'name': 'checkbox_eyelink_force_drift_correct'},
  {'type': 'combobox',
   'var': 'eyelink_pupil_size_mode',
   'label': 'Pupil-size mode',
   'tooltip': 'Determines whether pupil size is recorded as area or diameter',
   'name': 'combobox_eyelink_pupil_size_mode',
   'options': ['area', 'diameter']},
  {'type': 'line_edit',
   'label': 'SMI IP address',
   'var': 'smi_ip',
   'name': 'line_edit_smi_ip',
   'tooltip': "The tracker's IP address"},
  {'type': 'spinbox',
   'var': 'smi_send_port',
   'label': 'SMI send-port number',
   'min_val': 0,
   'max_val': 100000,
   'name': 'spinbox_smi_send_port',
   'tooltip': 'Port number for sending messages to the SMI tracker'},
  {'type': 'spinbox',
   'var': 'smi_recv_port',
   'label': 'SMI receive-port number',
   'min_val': 0,
   'max_val': 100000,
   'name': 'spinbox_smi_recv_port',
   'tooltip': 'Port number for receiving messages from the SMI tracker'},
  {'type': 'line_edit',
   'label': 'Tobii Glasses IPV4/IPv6 address',
   'var': 'tobiiglasses_address',
   'name': 'line_edit_tobiiglasses_address',
   'tooltip': 'The Tobii Pro Glasses IPv4/IPv6 address'},
  {'type': 'spinbox',
   'label': 'Tobii Glasses UDP port number',
   'var': 'tobiiglasses_udpport',
   'min_val': 0,
   'max_val': 100000,
   'name': 'spinbox_tobiiglasses_udpport',
   'tooltip': 'Port number for the Tobii Pro Glasses 2 eye-tracker'}]
