# OpenSesame 도움말

*이는 오프라인 도움말 페이지입니다. 인터넷에 연결되어 있다면, <http://osdoc.cogsci.nl>에서 온라인 문서를 찾을 수 있습니다.*

## 소개

OpenSesame는 사회과학을 위한 그래픽 실험 빌더입니다. OpenSesame를 사용하여 포인트 앤 클릭 그래픽 인터페이스를 사용하여 쉽게 실험을 생성할 수 있습니다. 복잡한 작업의 경우 OpenSesame는 [Python] 스크립팅을 지원합니다.

## 시작하기

시작하려면 튜토리얼을 거쳐보는 것이 가장 좋습니다. 이 외에도 다음 온라인에서 다양한 자료를 확인할 수 있습니다.

- <http://osdoc.cogsci.nl/tutorials/>

## 인용

작업에서 OpenSesame를 인용하려면 다음 참조를 사용하십시오:

- Mathôt, S., Schreij, D., & Theeuwes, J. (2012). OpenSesame: 사회과학을 위한 오픈 소스 그래픽 실험 빌더. *행동 연구 방법*, *44*(2), 314-324. doi:[10.3758/s13428-011-0168-7](http://dx.doi.org/10.3758/s13428-011-0168-7)

## 인터페이스

그래픽 인터페이스는 다음 구성 요소가 있습니다. 각 탭의 오른쪽 상단에 있는 도움말 아이콘을 클릭하여 상황에 맞는 도움말을 받을 수 있습니다.

- *메뉴*(창 상단)에는 파일 열기 및 저장, 프로그램 종료, 이 도움말 페이지 표시 등 일반적인 옵션이 표시됩니다.
- *메인 툴바*(메뉴 아래의 큰 버튼)는 메뉴에서 가장 관련성 있는 옵션 중 일부를 제공합니다.
- *아이템 툴바*(창 왼쪽의 큰 버튼)에 사용 가능한 아이템이 표시됩니다. 실험에 아이템을 추가하려면 아이템 툴바에서 개요 영역으로 드래그하세요.
- *개요 영역*(Control + \\)에서 실험의 트리 형태의 개요가 표시됩니다.
- *탭 영역*에는 아이템을 편집하기 위한 탭이 들어 있습니다. 개요 영역에서 아이템을 클릭하면 해당 탭이 탭 영역에서 열립니다. 도움말도 탭 영역에 표시됩니다.
- [파일 풀](opensesame://help.pool) (Control + P)에서 실험과 함께 제공되는 파일이 표시됩니다.
-   [변수 검사기](opensesame://help.extension.variable_inspector) (Control + I)에서 모든 감지된 변수를 표시합니다.
-   [디버그 창](opensesame://help.stdout) (Control + D)은 [IPython] 터미널입니다. 실험에서 표준 출력으로 출력하는 모든 내용(`print()` 사용)이 여기에 표시됩니다.

## 아이템

아이템은 실험의 구성 요소입니다. 10개의 핵심 아이템이 실험 구축에 필요한 기본 기능을 제공합니다. 실험에 항목을 추가하려면 아이템 툴바에서 개요 영역으로 드래그하세요.

- [루프](opensesame://help.loop) 아이템은 다른 아이템을 여러 번 실행합니다. 루프 아이템에서 독립 변수를 정의할 수도 있습니다.
- [시퀀스](opensesame://help.sequence) 아이템은 여러 다른 아이템을 순서대로 실행합니다.
- [스케치패드](opensesame://help.sketchpad) 아이템은 시각 자극을 제시합니다. 내장 그리기 도구를 사용하여 자극 디스플레이를 쉽게 생성할 수 있습니다.
- [피드백](opensesame://help.feedback) 아이템은 `스케치패드`와 유사하지만 미리 준비되지 않습니다. 따라서 참여자에게 피드백을 제공하는데 FEEDBACK 아이템을 사용할 수 있습니다.
- [샘플러](opensesame://help.sampler) 아이템은 단일 사운드 파일을 재생합니다.
- [신디사이저](opensesame://help.synth) 아이템은 단일 사운드를 생성합니다.
- [키보드_응답](opensesame://help.keyboard_response) 아이템은 키 누름 반응을 수집합니다.
- [마우스_응답](opensesame://help.mouse_response) 아이템은 마우스 클릭 반응을 수집합니다.
- [로거](opensesame://help.logger) 아이템은 변수를 로그 파일에 기록합니다.
- [인라인_스크립트](opensesame://help.inline_script)는 실험에 Python 코드를 포함시킵니다.

설치된 경우, 플러그인 아이템은 추가 기능을 제공합니다. 플러그인은 아이템 툴바에서 핵심 아이템과 함께 표시됩니다.

## 실험 실행

다음 모드에서 실험을 실행할 수 있습니다.

- 전체 화면 모드 (*Control+R* 또는 *실행 -> 전체 화면으로 실행*)
- 창 모드 (*Control+W* 또는 *실행 -> 창에서 실행*)
- 빠른 실행 모드 (*Control+Shift+W* 또는 *실행 -> 빠른 실행*)

빠른 실행 모드에서 실험은 창에서 즉시 시작되며, 로그 파일을 `quickrun.csv`로 사용하고 참가자 번호가 999로 지정됩니다. 이렇게 하면 개발 중에 유용합니다.

[python]: http://www.python.org/
[ipython]: http://www.ipython.org/