# OpenSesameヘルプ

*これはオフラインのヘルプページです。インターネットに接続している場合は、オンラインドキュメントを<http://osdoc.cogsci.nl>で見ることができます。*

## はじめに

OpenSesameは、社会科学のためのグラフィカルな実験ビルダーです。OpenSesameを使えば、ポイント＆クリックのグラフィカルインターフェースで簡単に実験を作成することができます。複雑なタスクには、[Python]スクリプトもサポートしています。

## はじめての方へ

はじめての方は、まずチュートリアルをやってみるのがおすすめです。チュートリアルやその他の情報はオンラインで見つけることができます：

- <http://osdoc.cogsci.nl/tutorials/>

## 引用方法

OpenSesameをあなたの作品で引用するには、以下の参考文献をお使いください:

- Mathôt, S., Schreij, D., & Theeuwes, J. (2012). OpenSesame: An open-source, graphical experiment builder for the social sciences. *Behavior Research Methods*, *44*(2), 314-324. doi:[10.3758/s13428-011-0168-7](http://dx.doi.org/10.3758/s13428-011-0168-7)

## インターフェース

グラフィカルインターフェースには以下のコンポーネントがあります。各タブの右上にあるヘルプアイコンをクリックすると、
タブに応じたヘルプが表示されます。

- *メニュー*（ウィンドウの上部に表示）では、ファイルの開封や保存、プログラムの終了、ヘルプページの表示といった共通のオプションが表示されます。
- *メインツールバー*（メニューの下のビッグボタン）は、メニューからの選択肢の中で最も関連性のあるオプションを提供します。
- *アイテムツールバー*（ウィンドウの左側のビッグボタン）には使用可能なアイテムが表示されます。実験にアイテムを追加するには、アイテムツールバーからアイテムをドラッグして概要エリアに入れます。
- *概要エリア*（Control + \\）は、実験のツリー状の概観を表示します。
- *タブエリア*には、アイテムを編集するためのタブが含まれています。概要エリアでアイテムをクリックすると、タブエリアに対応するタブが開きます。ヘルプもタブエリアで表示されます。
- [ファイルプール](opensesame://help.pool)（Control + P）は、実験にバンドルされたファイルを表示します。
-   [変数インスペクタ](opensesame://help.extension.variable_inspector)（Control + I）は、検出されたすべての変数を表示します。
-   [デバッグウィンドウ](opensesame://help.stdout)（Control + D）は、[IPython]ターミナルです。実験が標準出力（つまり `print()`を使って）に表示するすべてのものがここに表示されます。

## アイテム

アイテムは実験の構築要素です。 10のコアアイテムが実験の作成に必要な基本機能を提供します。実験にアイテムを追加するには、アイテムツールバーからアイテムをドラッグして概要エリアに入れます。

- [ループ](opensesame://help.loop)アイテムは、別のアイテムを複数回実行します。LOOPアイテムで独立変数も定義できます。
- [シーケンス](opensesame://help.sequence)アイテムは、複数の別のアイテムを順番に実行します。
- [スケッチパッド](opensesame://help.sketchpad)アイテムは、視覚刺激を提示します。組み込みの描画ツールを使って、簡単に刺激表示を作成できます。
- [フィードバック](opensesame://help.feedback)アイテムは `スケッチパッド` に似ていますが、事前に準備されていません。そのため、FEEDBACKアイテムは参加者にフィードバックを提供するために使用できます。
- [サンプラー](opensesame://help.sampler)アイテムは、単一の音声ファイルを再生します。
- [シンセ](opensesame://help.synth)アイテムは、単一の音を生成します。
- [キーボードレスポンス](opensesame://help.keyboard_response)アイテムは、キー押しの応答を収集します。
- [マウスレスポンス](opensesame://help.mouse_response)アイテムは、マウスクリックの応答を収集します。
- [ロガー](opensesame://help.logger)アイテムは、変数をログファイルに書き込みます。
- [インラインスクリプト](opensesame://help.inline_script)は、実験にPythonコードを埋め込みます。

インストールされている場合、プラグインアイテムは追加機能を提供します。プラグインは、アイテムツールバーのコアアイテムと並んで表示されます。

## 実験の実行

実験は次のモードで実行できます。

- フルスクリーンモード（*Control+R*または*Run -> Run fullscreen*）
- ウィンドウモード（*Control+W*または*Run -> Run in window*）
- クイックランモード（*Control+Shift+W*または*Run -> Quick run*）

クイックランモードでは、実験がすぐにウィンドウで開始し、ログファイル`quickrun.csv`と被験者番号999を使用します。これは開発中に便利です。

[python]: http://www.python.org/
[ipython]: http://www.ipython.org/