# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models

try:
    from django.utils.timezone import now as timezone_aware_now
except ImportError:
    from datetime import datetime
    timezone_aware_now = datetime.now

class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding field 'Switch.date_modified'
        db.add_column('gargoyle_switch', 'date_modified', self.gf('django.db.models.fields.DateTimeField')(default=timezone_aware_now), keep_default=False)


    def backwards(self, orm):

        # Deleting field 'Switch.date_modified'
        db.delete_column('gargoyle_switch', 'date_modified')


    models = {
        'gargoyle.switch': {
            'Meta': {'object_name': 'Switch'},
            'date_created': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'date_modified': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'description': ('django.db.models.fields.TextField', [], {'null': 'True'}),
            'key': ('django.db.models.fields.CharField', [], {'max_length': '32', 'primary_key': 'True'}),
            'label': ('django.db.models.fields.CharField', [], {'max_length': '32', 'null': 'True'}),
            'status': ('django.db.models.fields.PositiveSmallIntegerField', [], {'default': '1'}),
            'value': ('jsonfield.fields.JSONField', [], {'default': "'{}'"})
        }
    }

    complete_apps = ['gargoyle']
