from django import template

from tube.models import Video


register = template.Library()


class RandomVideoListNode(template.Node):
    def __init__(self, num, var_name):
        self.num = int(num)
        self.var_name = var_name

    def render(self, context):
        random_videos = Video.objects.visible().order_by('?')
        context[self.var_name] = list(random_videos[:self.num])
        return ''


def do_get_random_videos(parser, token):
    """
    Gets N random videos and populates the template context with a variable
    containing that value, whose name is defined by the 'as' clause.

    Syntax::

        {% get_random_videos [num] as [var_name] %}

    Example::

        {% get_random_videos 6 as random_video_list %}

    """
    bits = token.contents.split()
    if len(bits) == 4:
        if bits[2] != 'as':
            raise template.TemplateSyntaxError, "Second argument to '%s' tag must be 'as'" % bits[0]
        return RandomVideoListNode(num=bits[1], var_name=bits[3])
    else:
        raise template.TemplateSyntaxError, "'%s' tag takes three arguments" % bits[0]


register.tag('get_random_videos', do_get_random_videos)
