# -*- coding: utf-8 -*-

from django.contrib import admin
from django.utils.translation import ugettext_lazy as _

from tube.models import Video


class VideoAdmin(admin.ModelAdmin):
    date_hierarchy = 'date_added'
    fieldsets = (
        (None, {
            'fields': ('title', 'slug', 'youtube_url', 'description', 'visible')
        }),
        (_('Video detail'), {
            'fields': ('date_recorded', 'time_recorded', 'place', 'cameraman')
        }),
    )
    list_display = ('title', 'visible', 'date_added')
    list_filter = ('date_added', 'visible')
    prepopulated_fields = {'slug': ('title',)}
    search_fields = ('slug', 'place', 'title', 'description', 'cameraman',
                     'youtube_url')

admin.site.register(Video, VideoAdmin)
