"""
    WhyLabs API client

    WhyLabs API that enables end-to-end AI observability  # noqa: E501

    The version of the OpenAPI document: 0.1
    Contact: support@whylabs.ai
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from whylabs_client.api_client import ApiClient, Endpoint as _Endpoint
from whylabs_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from whylabs_client.model.column_schema import ColumnSchema
from whylabs_client.model.entity_schema import EntitySchema
from whylabs_client.model.list_models_response import ListModelsResponse
from whylabs_client.model.metric_schema import MetricSchema
from whylabs_client.model.model_metadata_response import ModelMetadataResponse
from whylabs_client.model.model_type import ModelType
from whylabs_client.model.response import Response
from whylabs_client.model.time_period import TimePeriod


class ModelsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_model_endpoint = _Endpoint(
            settings={
                'response_type': (ModelMetadataResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models',
                'operation_id': 'create_model',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_name',
                    'time_period',
                    'model_type',
                    'model_id',
                ],
                'required': [
                    'org_id',
                    'model_name',
                    'time_period',
                ],
                'nullable': [
                    'model_id',
                ],
                'enum': [
                ],
                'validation': [
                    'org_id',
                    'model_name',
                    'model_id',
                ]
            },
            root_map={
                'validations': {
                    ('org_id',): {
                        'max_length': 128,
                    },
                    ('model_name',): {
                        'max_length': 512,
                        'min_length': 4,
                    },
                    ('model_id',): {
                        'max_length': 128,
                        'min_length': 4,
                        'regex': {
                            'pattern': r'^[0-9a-zA-Z_-]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_name':
                        (str,),
                    'time_period':
                        (TimePeriod,),
                    'model_type':
                        (ModelType,),
                    'model_id':
                        (str, none_type,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_name': 'model_name',
                    'time_period': 'time_period',
                    'model_type': 'model_type',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_name': 'query',
                    'time_period': 'query',
                    'model_type': 'query',
                    'model_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.deactivate_model_endpoint = _Endpoint(
            settings={
                'response_type': (ModelMetadataResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}',
                'operation_id': 'deactivate_model',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                ],
                'required': [
                    'org_id',
                    'model_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_schema_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema',
                'operation_id': 'delete_entity_schema',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_schema_column_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema/column/{column_id}',
                'operation_id': 'delete_entity_schema_column',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'column_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'column_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'column_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'column_id': 'column_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'column_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_entity_schema_metric_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema/metric/{metric_label}',
                'operation_id': 'delete_entity_schema_metric',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'metric_label',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'metric_label',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'metric_label':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'metric_label': 'metric_label',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'metric_label': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_schema_endpoint = _Endpoint(
            settings={
                'response_type': (EntitySchema,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema',
                'operation_id': 'get_entity_schema',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_entity_schema_column_endpoint = _Endpoint(
            settings={
                'response_type': (ColumnSchema,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema/column/{column_id}',
                'operation_id': 'get_entity_schema_column',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'column_id',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'column_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'column_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'column_id': 'column_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'column_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_model_endpoint = _Endpoint(
            settings={
                'response_type': (ModelMetadataResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}',
                'operation_id': 'get_model',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                ],
                'required': [
                    'org_id',
                    'model_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_models_endpoint = _Endpoint(
            settings={
                'response_type': (ListModelsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models',
                'operation_id': 'list_models',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                ],
                'required': [
                    'org_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                },
                'location_map': {
                    'org_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.put_entity_schema_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema',
                'operation_id': 'put_entity_schema',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'entity_schema',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'entity_schema',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'entity_schema':
                        (EntitySchema,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'entity_schema': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_entity_schema_column_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema/column/{column_id}',
                'operation_id': 'put_entity_schema_column',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'column_id',
                    'column_schema',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'column_id',
                    'column_schema',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'column_id':
                        (str,),
                    'column_schema':
                        (ColumnSchema,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                    'column_id': 'column_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'column_id': 'path',
                    'column_schema': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.put_entity_schema_metric_endpoint = _Endpoint(
            settings={
                'response_type': (Response,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{dataset_id}/schema/metric',
                'operation_id': 'put_entity_schema_metric',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'dataset_id',
                    'metric_schema',
                ],
                'required': [
                    'org_id',
                    'dataset_id',
                    'metric_schema',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'dataset_id':
                        (str,),
                    'metric_schema':
                        (MetricSchema,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'dataset_id': 'dataset_id',
                },
                'location_map': {
                    'org_id': 'path',
                    'dataset_id': 'path',
                    'metric_schema': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_model_endpoint = _Endpoint(
            settings={
                'response_type': (ModelMetadataResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/v0/organizations/{org_id}/models/{model_id}',
                'operation_id': 'update_model',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'org_id',
                    'model_id',
                    'model_name',
                    'time_period',
                    'model_type',
                ],
                'required': [
                    'org_id',
                    'model_id',
                    'model_name',
                    'time_period',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'org_id':
                        (str,),
                    'model_id':
                        (str,),
                    'model_name':
                        (str,),
                    'time_period':
                        (TimePeriod,),
                    'model_type':
                        (ModelType,),
                },
                'attribute_map': {
                    'org_id': 'org_id',
                    'model_id': 'model_id',
                    'model_name': 'model_name',
                    'time_period': 'time_period',
                    'model_type': 'model_type',
                },
                'location_map': {
                    'org_id': 'path',
                    'model_id': 'path',
                    'model_name': 'query',
                    'time_period': 'query',
                    'model_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_model(
        self,
        org_id,
        model_name,
        time_period,
        **kwargs
    ):
        """Create a model with a given name and a time period  # noqa: E501

        Create a model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_model(org_id, model_name, time_period, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str): The organization ID
            model_name (str): The name of a model
            time_period (TimePeriod): The [TimePeriod] for data aggregation/alerting for a model

        Keyword Args:
            model_type (ModelType): The [ModelType] of the dataset. [optional]
            model_id (str, none_type): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['model_name'] = \
            model_name
        kwargs['time_period'] = \
            time_period
        return self.create_model_endpoint.call_with_http_info(**kwargs)

    def deactivate_model(
        self,
        org_id,
        model_id,
        **kwargs
    ):
        """Mark a model as inactive  # noqa: E501

        Mark a model as inactive  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deactivate_model(org_id, model_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str): The organization ID
            model_id (str): The model ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['model_id'] = \
            model_id
        return self.deactivate_model_endpoint.call_with_http_info(**kwargs)

    def delete_entity_schema(
        self,
        org_id,
        dataset_id,
        **kwargs
    ):
        """Delete the entity schema config for a given dataset.  # noqa: E501

        Delete the entity schema config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_schema(org_id, dataset_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        return self.delete_entity_schema_endpoint.call_with_http_info(**kwargs)

    def delete_entity_schema_column(
        self,
        org_id,
        dataset_id,
        column_id,
        **kwargs
    ):
        """Delete the entity schema of a single column for a given dataset.  # noqa: E501

        Delete the entity schema of a single column for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_schema_column(org_id, dataset_id, column_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            column_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['column_id'] = \
            column_id
        return self.delete_entity_schema_column_endpoint.call_with_http_info(**kwargs)

    def delete_entity_schema_metric(
        self,
        org_id,
        dataset_id,
        metric_label,
        **kwargs
    ):
        """Delete the schema of a single metric for a given dataset.  # noqa: E501

        Delete the schema of a single metric for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_entity_schema_metric(org_id, dataset_id, metric_label, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            metric_label (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['metric_label'] = \
            metric_label
        return self.delete_entity_schema_metric_endpoint.call_with_http_info(**kwargs)

    def get_entity_schema(
        self,
        org_id,
        dataset_id,
        **kwargs
    ):
        """Get the entity schema config for a given dataset.  # noqa: E501

        Get the entity schema config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_schema(org_id, dataset_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EntitySchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        return self.get_entity_schema_endpoint.call_with_http_info(**kwargs)

    def get_entity_schema_column(
        self,
        org_id,
        dataset_id,
        column_id,
        **kwargs
    ):
        """Get the entity schema of a single column for a given dataset.  # noqa: E501

        Get the entity schema of a single column for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_entity_schema_column(org_id, dataset_id, column_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            column_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ColumnSchema
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['column_id'] = \
            column_id
        return self.get_entity_schema_column_endpoint.call_with_http_info(**kwargs)

    def get_model(
        self,
        org_id,
        model_id,
        **kwargs
    ):
        """Get a model metadata  # noqa: E501

        Returns various metadata about a model  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_model(org_id, model_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str): The name of an organization
            model_id (str): The ID of a model

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['model_id'] = \
            model_id
        return self.get_model_endpoint.call_with_http_info(**kwargs)

    def list_models(
        self,
        org_id,
        **kwargs
    ):
        """Get a list of all of the model ids for an organization.  # noqa: E501

        Get a list of all of the model ids for an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_models(org_id, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str): Your company's unique organization ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ListModelsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        return self.list_models_endpoint.call_with_http_info(**kwargs)

    def put_entity_schema(
        self,
        org_id,
        dataset_id,
        entity_schema,
        **kwargs
    ):
        """Save the entity schema config for a given dataset.  # noqa: E501

        Save the entity schema config for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_entity_schema(org_id, dataset_id, entity_schema, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            entity_schema (EntitySchema):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['entity_schema'] = \
            entity_schema
        return self.put_entity_schema_endpoint.call_with_http_info(**kwargs)

    def put_entity_schema_column(
        self,
        org_id,
        dataset_id,
        column_id,
        column_schema,
        **kwargs
    ):
        """Save the entity schema of a single column for a given dataset.  # noqa: E501

        Save the entity schema of a single column for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_entity_schema_column(org_id, dataset_id, column_id, column_schema, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            column_id (str):
            column_schema (ColumnSchema):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['column_id'] = \
            column_id
        kwargs['column_schema'] = \
            column_schema
        return self.put_entity_schema_column_endpoint.call_with_http_info(**kwargs)

    def put_entity_schema_metric(
        self,
        org_id,
        dataset_id,
        metric_schema,
        **kwargs
    ):
        """Save the schema of a single metric for a given dataset.  # noqa: E501

        Save the schema of a single metric for a given dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.put_entity_schema_metric(org_id, dataset_id, metric_schema, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str):
            dataset_id (str):
            metric_schema (MetricSchema):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['dataset_id'] = \
            dataset_id
        kwargs['metric_schema'] = \
            metric_schema
        return self.put_entity_schema_metric_endpoint.call_with_http_info(**kwargs)

    def update_model(
        self,
        org_id,
        model_id,
        model_name,
        time_period,
        **kwargs
    ):
        """Update a model's metadata  # noqa: E501

        Update a model's metadata  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_model(org_id, model_id, model_name, time_period, async_req=True)
        >>> result = thread.get()

        Args:
            org_id (str): The organization ID
            model_id (str): The model ID
            model_name (str): The name of a model
            time_period (TimePeriod): The [TimePeriod] for data aggregation/alerting for a model

        Keyword Args:
            model_type (ModelType): The [ModelType] of the dataset. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ModelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['org_id'] = \
            org_id
        kwargs['model_id'] = \
            model_id
        kwargs['model_name'] = \
            model_name
        kwargs['time_period'] = \
            time_period
        return self.update_model_endpoint.call_with_http_info(**kwargs)

