/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import com.apple.concurrent.Dispatch;
import java.awt.AWTError;
import java.awt.EventQueue;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class CThreading {
    static String APPKIT_THREAD_NAME = "AWT-AppKit";
    static String FX_APPKIT_THREAD_NAME = "JavaFX Application Thread";

    static boolean isEventQueue() {
        return EventQueue.isDispatchThread();
    }

    private static boolean isAppKit() {
        return APPKIT_THREAD_NAME.equals(Thread.currentThread().getName()) || FX_APPKIT_THREAD_NAME.equals(Thread.currentThread().getName());
    }

    static boolean assertEventQueue() {
        boolean bl = CThreading.isEventQueue();
        assert (bl) : "Threading violation: not EventQueue thread";
        return bl;
    }

    static boolean assertNotEventQueue() {
        boolean bl = CThreading.isEventQueue();
        assert (bl) : "Threading violation: EventQueue thread";
        return bl;
    }

    static boolean assertAppKit() {
        boolean bl = CThreading.isAppKit();
        assert (bl) : "Threading violation: not AppKit thread";
        return bl;
    }

    static boolean assertNotAppKit() {
        boolean bl;
        boolean bl2 = bl = !CThreading.isAppKit();
        assert (bl) : "Threading violation: AppKit thread";
        return bl;
    }

    public static <V> V executeOnAppKit(Callable<V> callable) throws Throwable {
        if (!CThreading.isAppKit()) {
            Dispatch dispatch = Dispatch.getInstance();
            if (dispatch == null) {
                throw new AWTError("Could not get Dispatch object");
            }
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            dispatch.getNonBlockingMainQueueExecutor().execute(futureTask);
            try {
                return futureTask.get();
            }
            catch (InterruptedException interruptedException) {
                throw new AWTError(interruptedException.getMessage());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }
        return callable.call();
    }

    public static <V> V privilegedExecuteOnAppKit(Callable<V> callable) throws Exception {
        try {
            return (V)AccessController.doPrivileged(() -> {
                try {
                    return CThreading.executeOnAppKit(callable);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    throw new Exception(throwable);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeOnAppKit(Runnable runnable) {
        if (!CThreading.isAppKit()) {
            Dispatch dispatch = Dispatch.getInstance();
            if (dispatch == null) throw new AWTError("Could not get Dispatch object");
            dispatch.getNonBlockingMainQueueExecutor().execute(runnable);
            return;
        } else {
            runnable.run();
        }
    }
}

