/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.lwawt.macosx.CPlatformView;

public abstract class CGLSurfaceData
extends OGLSurfaceData {
    protected final int scale;
    protected final int width;
    protected final int height;
    protected CPlatformView pView;
    private CGLGraphicsConfig graphicsConfig;

    native void validate(int var1, int var2, int var3, int var4, boolean var5);

    private native void initOps(long var1, long var3, long var5, int var7, int var8, boolean var9);

    @Override
    protected native boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    protected CGLSurfaceData(CGLGraphicsConfig cGLGraphicsConfig, ColorModel colorModel, int n, int n2, int n3) {
        super(cGLGraphicsConfig, colorModel, n);
        this.scale = n == 3 ? 1 : cGLGraphicsConfig.getDevice().getScaleFactor();
        this.width = n2 * this.scale;
        this.height = n3 * this.scale;
    }

    protected CGLSurfaceData(CPlatformView cPlatformView, CGLGraphicsConfig cGLGraphicsConfig, ColorModel colorModel, int n, int n2, int n3) {
        this(cGLGraphicsConfig, colorModel, n, n2, n3);
        this.pView = cPlatformView;
        this.graphicsConfig = cGLGraphicsConfig;
        long l = cGLGraphicsConfig.getNativeConfigInfo();
        long l2 = 0L;
        boolean bl = true;
        if (cPlatformView != null) {
            l2 = cPlatformView.getAWTView();
            bl = cPlatformView.isOpaque();
        }
        CGLGraphicsConfig.refPConfigInfo(l);
        this.initOps(l, l2, 0L, 0, 0, bl);
    }

    protected CGLSurfaceData(CGLLayer cGLLayer, CGLGraphicsConfig cGLGraphicsConfig, ColorModel colorModel, int n, int n2, int n3) {
        this(cGLGraphicsConfig, colorModel, n, n2, n3);
        this.graphicsConfig = cGLGraphicsConfig;
        long l = cGLGraphicsConfig.getNativeConfigInfo();
        long l2 = 0L;
        boolean bl = true;
        if (cGLLayer != null) {
            l2 = cGLLayer.getPointer();
            bl = cGLLayer.isOpaque();
        }
        CGLGraphicsConfig.refPConfigInfo(l);
        this.initOps(l, 0L, l2, 0, 0, bl);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static CGLWindowSurfaceData createData(CPlatformView cPlatformView) {
        CGLGraphicsConfig cGLGraphicsConfig = CGLSurfaceData.getGC(cPlatformView);
        return new CGLWindowSurfaceData(cPlatformView, cGLGraphicsConfig);
    }

    public static CGLLayerSurfaceData createData(CGLLayer cGLLayer) {
        CGLGraphicsConfig cGLGraphicsConfig = CGLSurfaceData.getGC(cGLLayer);
        Rectangle rectangle = cGLLayer.getBounds();
        return new CGLLayerSurfaceData(cGLLayer, cGLGraphicsConfig, rectangle.width, rectangle.height);
    }

    public static CGLOffScreenSurfaceData createData(CPlatformView cPlatformView, Image image, int n) {
        CGLGraphicsConfig cGLGraphicsConfig = CGLSurfaceData.getGC(cPlatformView);
        Rectangle rectangle = cPlatformView.getBounds();
        if (n == 4) {
            return new CGLOffScreenSurfaceData(cPlatformView, cGLGraphicsConfig, rectangle.width, rectangle.height, image, cGLGraphicsConfig.getColorModel(), 4);
        }
        return new CGLVSyncOffScreenSurfaceData(cPlatformView, cGLGraphicsConfig, rectangle.width, rectangle.height, image, cGLGraphicsConfig.getColorModel(), n);
    }

    public static CGLOffScreenSurfaceData createData(CGLGraphicsConfig cGLGraphicsConfig, int n, int n2, ColorModel colorModel, Image image, int n3) {
        return new CGLOffScreenSurfaceData(null, cGLGraphicsConfig, n, n2, image, colorModel, n3);
    }

    public static CGLGraphicsConfig getGC(CPlatformView cPlatformView) {
        if (cPlatformView != null) {
            return (CGLGraphicsConfig)cPlatformView.getGraphicsConfiguration();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return (CGLGraphicsConfig)graphicsDevice.getDefaultConfiguration();
    }

    public static CGLGraphicsConfig getGC(CGLLayer cGLLayer) {
        return (CGLGraphicsConfig)cGLLayer.getGraphicsConfiguration();
    }

    public void validate() {
    }

    @Override
    public double getDefaultScaleX() {
        return this.scale;
    }

    @Override
    public double getDefaultScaleY() {
        return this.scale;
    }

    protected native void clearWindow();

    private static native long createCGLContextOnSurface(CGLSurfaceData var0, long var1);

    public static long createOGLContextOnSurface(Graphics graphics, long l) {
        SurfaceData surfaceData = ((SunGraphics2D)graphics).surfaceData;
        if (surfaceData instanceof CGLSurfaceData) {
            CGLSurfaceData cGLSurfaceData = (CGLSurfaceData)surfaceData;
            return CGLSurfaceData.createCGLContextOnSurface(cGLSurfaceData, l);
        }
        return 0L;
    }

    static native boolean makeCGLContextCurrentOnSurface(CGLSurfaceData var0, long var1);

    public static boolean makeOGLContextCurrentOnSurface(Graphics graphics, long l) {
        SurfaceData surfaceData = ((SunGraphics2D)graphics).surfaceData;
        if (l != 0L && surfaceData instanceof CGLSurfaceData) {
            CGLSurfaceData cGLSurfaceData = (CGLSurfaceData)surfaceData;
            return CGLSurfaceData.makeCGLContextCurrentOnSurface(cGLSurfaceData, l);
        }
        return false;
    }

    private static native void destroyCGLContext(long var0);

    public static void destroyOGLContext(long l) {
        if (l != 0L) {
            CGLSurfaceData.destroyCGLContext(l);
        }
    }

    static void dispose(long l, long l2) {
        OGLSurfaceData.dispose(l, l2);
        CGLGraphicsConfig.deRefPConfigInfo(l2);
    }

    public static class CGLOffScreenSurfaceData
    extends CGLSurfaceData {
        private Image offscreenImage;

        public CGLOffScreenSurfaceData(CPlatformView cPlatformView, CGLGraphicsConfig cGLGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(cPlatformView, cGLGraphicsConfig, colorModel, n3, n, n2);
            this.offscreenImage = image;
            this.initSurface(this.width, this.height);
        }

        @Override
        public SurfaceData getReplacement() {
            return CGLOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        @Override
        public Rectangle getBounds() {
            if (this.type == 4) {
                Rectangle rectangle = this.pView.getBounds();
                return new Rectangle(0, 0, rectangle.width, rectangle.height);
            }
            return new Rectangle(this.width, this.height);
        }

        @Override
        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class CGLVSyncOffScreenSurfaceData
    extends CGLOffScreenSurfaceData {
        private CGLOffScreenSurfaceData flipSurface;

        public CGLVSyncOffScreenSurfaceData(CPlatformView cPlatformView, CGLGraphicsConfig cGLGraphicsConfig, int n, int n2, Image image, ColorModel colorModel, int n3) {
            super(cPlatformView, cGLGraphicsConfig, n, n2, image, colorModel, n3);
            this.flipSurface = CGLSurfaceData.createData(cPlatformView, image, 4);
        }

        public SurfaceData getFlipSurface() {
            return this.flipSurface;
        }

        @Override
        public void flush() {
            this.flipSurface.flush();
            super.flush();
        }
    }

    public static class CGLLayerSurfaceData
    extends CGLSurfaceData {
        private CGLLayer layer;

        public CGLLayerSurfaceData(CGLLayer cGLLayer, CGLGraphicsConfig cGLGraphicsConfig, int n, int n2) {
            super(cGLLayer, cGLGraphicsConfig, cGLGraphicsConfig.getColorModel(), 5, n, n2);
            this.layer = cGLLayer;
            this.initSurface(this.width, this.height);
        }

        @Override
        public SurfaceData getReplacement() {
            return this.layer.getSurfaceData();
        }

        @Override
        boolean isOnScreen() {
            return true;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(this.width, this.height);
        }

        @Override
        public Object getDestination() {
            return this.layer.getDestination();
        }

        @Override
        public int getTransparency() {
            return this.layer.getTransparency();
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.clearWindow();
        }
    }

    public static class CGLWindowSurfaceData
    extends CGLSurfaceData {
        public CGLWindowSurfaceData(CPlatformView cPlatformView, CGLGraphicsConfig cGLGraphicsConfig) {
            super(cPlatformView, cGLGraphicsConfig, cGLGraphicsConfig.getColorModel(), 1, 0, 0);
        }

        @Override
        public SurfaceData getReplacement() {
            return this.pView.getSurfaceData();
        }

        @Override
        public Rectangle getBounds() {
            Rectangle rectangle = this.pView.getBounds();
            return new Rectangle(0, 0, rectangle.width, rectangle.height);
        }

        @Override
        public Object getDestination() {
            return this.pView.getDestination();
        }

        @Override
        public void validate() {
            OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
            oGLRenderQueue.lock();
            try {
                oGLRenderQueue.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle rectangle = pView.getBounds();
                        this.validate(0, 0, rectangle.width, rectangle.height, pView.isOpaque());
                    }
                });
            }
            finally {
                oGLRenderQueue.unlock();
            }
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.clearWindow();
        }
    }
}

