/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.Helpers;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.RendererContext;

final class Stroker
implements PathConsumer2D,
MarlinConst {
    private static final int MOVE_TO = 0;
    private static final int DRAWING_OP_TO = 1;
    private static final int CLOSE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private static final float ROUND_JOIN_THRESHOLD = 0.015258789f;
    private static final float C = 0.5522848f;
    private static final int MAX_N_CURVES = 11;
    private PathConsumer2D out;
    private int capStyle;
    private int joinStyle;
    private float lineWidth2;
    private float invHalfLineWidth2Sq;
    private final float[] offset0 = new float[2];
    private final float[] offset1 = new float[2];
    private final float[] offset2 = new float[2];
    private final float[] miter = new float[2];
    private float miterLimitSq;
    private int prev;
    private float sx0;
    private float sy0;
    private float sdx;
    private float sdy;
    private float cx0;
    private float cy0;
    private float cdx;
    private float cdy;
    private float smx;
    private float smy;
    private float cmx;
    private float cmy;
    private final PolyStack reverse;
    private final float[] middle = new float[16];
    private final float[] lp = new float[8];
    private final float[] rp = new float[8];
    private final float[] subdivTs = new float[10];
    final RendererContext rdrCtx;
    final Curve curve;

    Stroker(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.reverse = new PolyStack(rendererContext);
        this.curve = rendererContext.curve;
    }

    Stroker init(PathConsumer2D pathConsumer2D, float f, int n, int n2, float f2) {
        this.out = pathConsumer2D;
        this.lineWidth2 = f / 2.0f;
        this.invHalfLineWidth2Sq = 1.0f / (2.0f * this.lineWidth2 * this.lineWidth2);
        this.capStyle = n;
        this.joinStyle = n2;
        float f3 = f2 * this.lineWidth2;
        this.miterLimitSq = f3 * f3;
        this.prev = 2;
        this.rdrCtx.stroking = 1;
        return this;
    }

    void dispose() {
        this.reverse.dispose();
    }

    private static void computeOffset(float f, float f2, float f3, float[] fArray) {
        float f4 = f * f + f2 * f2;
        if (f4 == 0.0f) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        } else {
            f4 = (float)Math.sqrt(f4);
            fArray[0] = f2 * f3 / f4;
            fArray[1] = -(f * f3) / f4;
        }
    }

    private static boolean isCW(float f, float f2, float f3, float f4) {
        return f * f4 <= f2 * f3;
    }

    private void drawRoundJoin(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, float f7) {
        if (f3 == 0.0f && f4 == 0.0f || f5 == 0.0f && f6 == 0.0f) {
            return;
        }
        float f8 = f3 - f5;
        float f9 = f4 - f6;
        float f10 = f8 * f8 + f9 * f9;
        if (f10 < f7) {
            return;
        }
        if (bl) {
            f3 = -f3;
            f4 = -f4;
            f5 = -f5;
            f6 = -f6;
        }
        this.drawRoundJoin(f, f2, f3, f4, f5, f6, bl);
    }

    private void drawRoundJoin(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7 = f3 * f5 + f4 * f6;
        int n = f7 >= 0.0f ? 1 : 2;
        switch (n) {
            case 1: {
                this.drawBezApproxForArc(f, f2, f3, f4, f5, f6, bl);
                break;
            }
            case 2: {
                float f8 = f6 - f4;
                float f9 = f3 - f5;
                float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                float f11 = this.lineWidth2 / f10;
                float f12 = f8 * f11;
                float f13 = f9 * f11;
                if (bl) {
                    f12 = -f12;
                    f13 = -f13;
                }
                this.drawBezApproxForArc(f, f2, f3, f4, f12, f13, bl);
                this.drawBezApproxForArc(f, f2, f12, f13, f5, f6, bl);
                break;
            }
        }
    }

    private void drawBezApproxForArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7 = (f3 * f5 + f4 * f6) * this.invHalfLineWidth2Sq;
        if (f7 >= 0.5f) {
            return;
        }
        float f8 = (float)(1.3333333333333333 * Math.sqrt(0.5 - (double)f7) / (1.0 + Math.sqrt((double)f7 + 0.5)));
        if (bl) {
            f8 = -f8;
        }
        float f9 = f + f3;
        float f10 = f2 + f4;
        float f11 = f9 - f8 * f4;
        float f12 = f10 + f8 * f3;
        float f13 = f + f5;
        float f14 = f2 + f6;
        float f15 = f13 + f8 * f6;
        float f16 = f14 - f8 * f5;
        this.emitCurveTo(f9, f10, f11, f12, f15, f16, f13, f14, bl);
    }

    private void drawRoundCap(float f, float f2, float f3, float f4) {
        float f5 = 0.5522848f * f3;
        float f6 = 0.5522848f * f4;
        this.emitCurveTo(f + f3 - f6, f2 + f4 + f5, f - f4 + f5, f2 + f3 + f6, f - f4, f2 + f3);
        this.emitCurveTo(f - f4 - f5, f2 + f3 - f6, f - f3 - f6, f2 - f4 + f5, f - f3, f2 - f4);
    }

    private static void computeIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float[] fArray, int n) {
        float f9 = f3 - f;
        float f10 = f4 - f2;
        float f11 = f7 - f5;
        float f12 = f8 - f6;
        float f13 = f9 * f12 - f11 * f10;
        float f14 = f11 * (f2 - f6) - f12 * (f - f5);
        fArray[n++] = f + (f14 /= f13) * f9;
        fArray[n] = f2 + f14 * f10;
    }

    private void drawMiter(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        if (f9 == f7 && f10 == f8 || f == 0.0f && f2 == 0.0f || f5 == 0.0f && f6 == 0.0f) {
            return;
        }
        if (bl) {
            f7 = -f7;
            f8 = -f8;
            f9 = -f9;
            f10 = -f10;
        }
        Stroker.computeIntersection(f3 - f + f7, f4 - f2 + f8, f3 + f7, f4 + f8, f5 + f3 + f9, f6 + f4 + f10, f3 + f9, f4 + f10, this.miter, 0);
        float f11 = this.miter[0];
        float f12 = this.miter[1];
        float f13 = (f11 - f3) * (f11 - f3) + (f12 - f4) * (f12 - f4);
        if (f13 < this.miterLimitSq) {
            this.emitLineTo(f11, f12, bl);
        }
    }

    @Override
    public void moveTo(float f, float f2) {
        if (this.prev == 1) {
            this.finish();
        }
        this.sx0 = this.cx0 = f;
        this.sy0 = this.cy0 = f2;
        this.sdx = 1.0f;
        this.cdx = 1.0f;
        this.sdy = 0.0f;
        this.cdy = 0.0f;
        this.prev = 0;
    }

    @Override
    public void lineTo(float f, float f2) {
        float f3 = f - this.cx0;
        float f4 = f2 - this.cy0;
        if (f3 == 0.0f && f4 == 0.0f) {
            f3 = 1.0f;
        }
        Stroker.computeOffset(f3, f4, this.lineWidth2, this.offset0);
        float f5 = this.offset0[0];
        float f6 = this.offset0[1];
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, f3, f4, this.cmx, this.cmy, f5, f6);
        this.emitLineTo(this.cx0 + f5, this.cy0 + f6);
        this.emitLineTo(f + f5, f2 + f6);
        this.emitLineToRev(this.cx0 - f5, this.cy0 - f6);
        this.emitLineToRev(f - f5, f2 - f6);
        this.cmx = f5;
        this.cmy = f6;
        this.cdx = f3;
        this.cdy = f4;
        this.cx0 = f;
        this.cy0 = f2;
        this.prev = 1;
    }

    @Override
    public void closePath() {
        if (this.prev != 1) {
            if (this.prev == 2) {
                return;
            }
            this.emitMoveTo(this.cx0, this.cy0 - this.lineWidth2);
            this.smx = 0.0f;
            this.cmx = 0.0f;
            this.cmy = this.smy = -this.lineWidth2;
            this.sdx = 1.0f;
            this.cdx = 1.0f;
            this.sdy = 0.0f;
            this.cdy = 0.0f;
            this.finish();
            return;
        }
        if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
            this.lineTo(this.sx0, this.sy0);
        }
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, this.sdx, this.sdy, this.cmx, this.cmy, this.smx, this.smy);
        this.emitLineTo(this.sx0 + this.smx, this.sy0 + this.smy);
        this.emitMoveTo(this.sx0 - this.smx, this.sy0 - this.smy);
        this.emitReverse();
        this.prev = 2;
        this.emitClose();
    }

    private void emitReverse() {
        this.reverse.popAll(this.out);
    }

    @Override
    public void pathDone() {
        if (this.prev == 1) {
            this.finish();
        }
        this.out.pathDone();
        this.prev = 2;
        this.dispose();
    }

    private void finish() {
        if (this.capStyle == 1) {
            this.drawRoundCap(this.cx0, this.cy0, this.cmx, this.cmy);
        } else if (this.capStyle == 2) {
            this.emitLineTo(this.cx0 - this.cmy + this.cmx, this.cy0 + this.cmx + this.cmy);
            this.emitLineTo(this.cx0 - this.cmy - this.cmx, this.cy0 + this.cmx - this.cmy);
        }
        this.emitReverse();
        if (this.capStyle == 1) {
            this.drawRoundCap(this.sx0, this.sy0, -this.smx, -this.smy);
        } else if (this.capStyle == 2) {
            this.emitLineTo(this.sx0 + this.smy - this.smx, this.sy0 - this.smx - this.smy);
            this.emitLineTo(this.sx0 + this.smy + this.smx, this.sy0 - this.smx + this.smy);
        }
        this.emitClose();
    }

    private void emitMoveTo(float f, float f2) {
        this.out.moveTo(f, f2);
    }

    private void emitLineTo(float f, float f2) {
        this.out.lineTo(f, f2);
    }

    private void emitLineToRev(float f, float f2) {
        this.reverse.pushLine(f, f2);
    }

    private void emitLineTo(float f, float f2, boolean bl) {
        if (bl) {
            this.emitLineToRev(f, f2);
        } else {
            this.emitLineTo(f, f2);
        }
    }

    private void emitQuadTo(float f, float f2, float f3, float f4) {
        this.out.quadTo(f, f2, f3, f4);
    }

    private void emitQuadToRev(float f, float f2, float f3, float f4) {
        this.reverse.pushQuad(f, f2, f3, f4);
    }

    private void emitCurveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.out.curveTo(f, f2, f3, f4, f5, f6);
    }

    private void emitCurveToRev(float f, float f2, float f3, float f4, float f5, float f6) {
        this.reverse.pushCubic(f, f2, f3, f4, f5, f6);
    }

    private void emitCurveTo(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
        if (bl) {
            this.reverse.pushCubic(f, f2, f3, f4, f5, f6);
        } else {
            this.out.curveTo(f3, f4, f5, f6, f7, f8);
        }
    }

    private void emitClose() {
        this.out.closePath();
    }

    private void drawJoin(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (this.prev != 1) {
            this.emitMoveTo(f3 + f9, f4 + f10);
            this.sdx = f5;
            this.sdy = f6;
            this.smx = f9;
            this.smy = f10;
        } else {
            boolean bl = Stroker.isCW(f, f2, f5, f6);
            if (this.joinStyle == 0) {
                this.drawMiter(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, bl);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(f3, f4, f7, f8, f9, f10, bl, 0.015258789f);
            }
            this.emitLineTo(f3, f4, !bl);
        }
        this.prev = 1;
    }

    private static boolean within(float f, float f2, float f3, float f4, float f5) {
        assert (f5 > 0.0f) : "";
        return Helpers.within(f, f3, f5) && Helpers.within(f2, f4, f5);
    }

    private void getLineOffsets(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2) {
        Stroker.computeOffset(f3 - f, f4 - f2, this.lineWidth2, this.offset0);
        float f5 = this.offset0[0];
        float f6 = this.offset0[1];
        fArray[0] = f + f5;
        fArray[1] = f2 + f6;
        fArray[2] = f3 + f5;
        fArray[3] = f4 + f6;
        fArray2[0] = f - f5;
        fArray2[1] = f2 - f6;
        fArray2[2] = f3 - f5;
        fArray2[3] = f4 - f6;
    }

    private int computeOffsetCubic(float[] fArray, int n, float[] fArray2, float[] fArray3) {
        float f = fArray[n + 0];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + 2];
        float f4 = fArray[n + 3];
        float f5 = fArray[n + 4];
        float f6 = fArray[n + 5];
        float f7 = fArray[n + 6];
        float f8 = fArray[n + 7];
        float f9 = f7 - f5;
        float f10 = f8 - f6;
        float f11 = f3 - f;
        float f12 = f4 - f2;
        boolean bl = Stroker.within(f, f2, f3, f4, 6.0f * Math.ulp(f4));
        boolean bl2 = Stroker.within(f5, f6, f7, f8, 6.0f * Math.ulp(f8));
        if (bl && bl2) {
            this.getLineOffsets(f, f2, f7, f8, fArray2, fArray3);
            return 4;
        }
        if (bl) {
            f11 = f5 - f;
            f12 = f6 - f2;
        } else if (bl2) {
            f9 = f7 - f3;
            f10 = f8 - f4;
        }
        float f13 = f11 * f9 + f12 * f10;
        f13 *= f13;
        float f14 = f11 * f11 + f12 * f12;
        float f15 = f9 * f9 + f10 * f10;
        if (Helpers.within(f13, f14 * f15, 4.0f * Math.ulp(f13))) {
            this.getLineOffsets(f, f2, f7, f8, fArray2, fArray3);
            return 4;
        }
        float f16 = (f + 3.0f * (f3 + f5) + f7) / 8.0f;
        float f17 = (f2 + 3.0f * (f4 + f6) + f8) / 8.0f;
        float f18 = f5 + f7 - f - f3;
        float f19 = f6 + f8 - f2 - f4;
        Stroker.computeOffset(f11, f12, this.lineWidth2, this.offset0);
        Stroker.computeOffset(f18, f19, this.lineWidth2, this.offset1);
        Stroker.computeOffset(f9, f10, this.lineWidth2, this.offset2);
        float f20 = f + this.offset0[0];
        float f21 = f2 + this.offset0[1];
        float f22 = f16 + this.offset1[0];
        float f23 = f17 + this.offset1[1];
        float f24 = f7 + this.offset2[0];
        float f25 = f8 + this.offset2[1];
        float f26 = 4.0f / (3.0f * (f11 * f10 - f12 * f9));
        float f27 = 2.0f * f22 - f20 - f24;
        float f28 = 2.0f * f23 - f21 - f25;
        float f29 = f26 * (f10 * f27 - f9 * f28);
        float f30 = f26 * (f11 * f28 - f12 * f27);
        float f31 = f20 + f29 * f11;
        float f32 = f21 + f29 * f12;
        float f33 = f24 + f30 * f9;
        float f34 = f25 + f30 * f10;
        fArray2[0] = f20;
        fArray2[1] = f21;
        fArray2[2] = f31;
        fArray2[3] = f32;
        fArray2[4] = f33;
        fArray2[5] = f34;
        fArray2[6] = f24;
        fArray2[7] = f25;
        f20 = f - this.offset0[0];
        f21 = f2 - this.offset0[1];
        f24 = f7 - this.offset2[0];
        f25 = f8 - this.offset2[1];
        f27 = 2.0f * (f22 -= 2.0f * this.offset1[0]) - f20 - f24;
        f28 = 2.0f * (f23 -= 2.0f * this.offset1[1]) - f21 - f25;
        f29 = f26 * (f10 * f27 - f9 * f28);
        f30 = f26 * (f11 * f28 - f12 * f27);
        f31 = f20 + f29 * f11;
        f32 = f21 + f29 * f12;
        f33 = f24 + f30 * f9;
        f34 = f25 + f30 * f10;
        fArray3[0] = f20;
        fArray3[1] = f21;
        fArray3[2] = f31;
        fArray3[3] = f32;
        fArray3[4] = f33;
        fArray3[5] = f34;
        fArray3[6] = f24;
        fArray3[7] = f25;
        return 8;
    }

    private int computeOffsetQuad(float[] fArray, int n, float[] fArray2, float[] fArray3) {
        float f = fArray[n + 0];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + 2];
        float f4 = fArray[n + 3];
        float f5 = fArray[n + 4];
        float f6 = fArray[n + 5];
        float f7 = f5 - f3;
        float f8 = f6 - f4;
        float f9 = f3 - f;
        float f10 = f4 - f2;
        Stroker.computeOffset(f9, f10, this.lineWidth2, this.offset0);
        Stroker.computeOffset(f7, f8, this.lineWidth2, this.offset1);
        fArray2[0] = f + this.offset0[0];
        fArray2[1] = f2 + this.offset0[1];
        fArray2[4] = f5 + this.offset1[0];
        fArray2[5] = f6 + this.offset1[1];
        fArray3[0] = f - this.offset0[0];
        fArray3[1] = f2 - this.offset0[1];
        fArray3[4] = f5 - this.offset1[0];
        fArray3[5] = f6 - this.offset1[1];
        float f11 = fArray2[0];
        float f12 = fArray2[1];
        float f13 = fArray2[4];
        float f14 = fArray2[5];
        Stroker.computeIntersection(f11, f12, f11 + f9, f12 + f10, f13, f14, f13 - f7, f14 - f8, fArray2, 2);
        float f15 = fArray2[2];
        float f16 = fArray2[3];
        if (!Stroker.isFinite(f15) || !Stroker.isFinite(f16)) {
            f11 = fArray3[0];
            f12 = fArray3[1];
            f13 = fArray3[4];
            f14 = fArray3[5];
            Stroker.computeIntersection(f11, f12, f11 + f9, f12 + f10, f13, f14, f13 - f7, f14 - f8, fArray3, 2);
            f15 = fArray3[2];
            f16 = fArray3[3];
            if (!Stroker.isFinite(f15) || !Stroker.isFinite(f16)) {
                this.getLineOffsets(f, f2, f5, f6, fArray2, fArray3);
                return 4;
            }
            fArray2[2] = 2.0f * f3 - f15;
            fArray2[3] = 2.0f * f4 - f16;
            return 6;
        }
        fArray3[2] = 2.0f * f3 - f15;
        fArray3[3] = 2.0f * f4 - f16;
        return 6;
    }

    private static boolean isFinite(float f) {
        return Float.NEGATIVE_INFINITY < f && f < Float.POSITIVE_INFINITY;
    }

    private static int findSubdivPoints(Curve curve, float[] fArray, float[] fArray2, int n, float f) {
        float f2 = fArray[2] - fArray[0];
        float f3 = fArray[3] - fArray[1];
        if (f3 != 0.0f && f2 != 0.0f) {
            float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
            float f5 = f2 / f4;
            float f6 = f3 / f4;
            float f7 = f5 * fArray[0] + f6 * fArray[1];
            float f8 = f5 * fArray[1] - f6 * fArray[0];
            float f9 = f5 * fArray[2] + f6 * fArray[3];
            float f10 = f5 * fArray[3] - f6 * fArray[2];
            float f11 = f5 * fArray[4] + f6 * fArray[5];
            float f12 = f5 * fArray[5] - f6 * fArray[4];
            switch (n) {
                case 8: {
                    float f13 = f5 * fArray[6] + f6 * fArray[7];
                    float f14 = f5 * fArray[7] - f6 * fArray[6];
                    curve.set(f7, f8, f9, f10, f11, f12, f13, f14);
                    break;
                }
                case 6: {
                    curve.set(f7, f8, f9, f10, f11, f12);
                    break;
                }
            }
        } else {
            curve.set(fArray, n);
        }
        int n2 = 0;
        n2 += curve.dxRoots(fArray2, n2);
        n2 += curve.dyRoots(fArray2, n2);
        if (n == 8) {
            n2 += curve.infPoints(fArray2, n2);
        }
        n2 += curve.rootsOfROCMinusW(fArray2, n2, f, 1.0E-4f);
        n2 = Helpers.filterOutNotInAB(fArray2, 0, n2, 1.0E-4f, 0.9999f);
        Helpers.isort(fArray2, 0, n2);
        return n2;
    }

    @Override
    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        boolean bl;
        float[] fArray = this.middle;
        fArray[0] = this.cx0;
        fArray[1] = this.cy0;
        fArray[2] = f;
        fArray[3] = f2;
        fArray[4] = f3;
        fArray[5] = f4;
        fArray[6] = f5;
        fArray[7] = f6;
        float f8 = fArray[6];
        float f9 = fArray[7];
        float f10 = fArray[2] - fArray[0];
        float f11 = fArray[3] - fArray[1];
        float f12 = fArray[6] - fArray[4];
        float f13 = fArray[7] - fArray[5];
        boolean bl2 = f10 == 0.0f && f11 == 0.0f;
        boolean bl3 = bl = f12 == 0.0f && f13 == 0.0f;
        if (bl2) {
            f10 = fArray[4] - fArray[0];
            f11 = fArray[5] - fArray[1];
            if (f10 == 0.0f && f11 == 0.0f) {
                f10 = fArray[6] - fArray[0];
                f11 = fArray[7] - fArray[1];
            }
        }
        if (bl) {
            f12 = fArray[6] - fArray[2];
            f13 = fArray[7] - fArray[3];
            if (f12 == 0.0f && f13 == 0.0f) {
                f12 = fArray[6] - fArray[0];
                f13 = fArray[7] - fArray[1];
            }
        }
        if (f10 == 0.0f && f11 == 0.0f) {
            this.lineTo(fArray[0], fArray[1]);
            return;
        }
        if (Math.abs(f10) < 0.1f && Math.abs(f11) < 0.1f) {
            f7 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            f10 /= f7;
            f11 /= f7;
        }
        if (Math.abs(f12) < 0.1f && Math.abs(f13) < 0.1f) {
            f7 = (float)Math.sqrt(f12 * f12 + f13 * f13);
            f12 /= f7;
            f13 /= f7;
        }
        Stroker.computeOffset(f10, f11, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, f10, f11, this.cmx, this.cmy, this.offset0[0], this.offset0[1]);
        int n = Stroker.findSubdivPoints(this.curve, fArray, this.subdivTs, 8, this.lineWidth2);
        float[] fArray2 = this.lp;
        float[] fArray3 = this.rp;
        int n2 = 0;
        Curve.BreakPtrIterator breakPtrIterator = this.curve.breakPtsAtTs(fArray, 8, this.subdivTs, n);
        while (breakPtrIterator.hasNext()) {
            int n3 = breakPtrIterator.next();
            n2 = this.computeOffsetCubic(fArray, n3, fArray2, fArray3);
            this.emitLineTo(fArray2[0], fArray2[1]);
            switch (n2) {
                case 8: {
                    this.emitCurveTo(fArray2[2], fArray2[3], fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
                    this.emitCurveToRev(fArray3[0], fArray3[1], fArray3[2], fArray3[3], fArray3[4], fArray3[5]);
                    break;
                }
                case 4: {
                    this.emitLineTo(fArray2[2], fArray2[3]);
                    this.emitLineToRev(fArray3[0], fArray3[1]);
                    break;
                }
            }
            this.emitLineToRev(fArray3[n2 - 2], fArray3[n2 - 1]);
        }
        this.cmx = (fArray2[n2 - 2] - fArray3[n2 - 2]) / 2.0f;
        this.cmy = (fArray2[n2 - 1] - fArray3[n2 - 1]) / 2.0f;
        this.cdx = f12;
        this.cdy = f13;
        this.cx0 = f8;
        this.cy0 = f9;
        this.prev = 1;
    }

    @Override
    public void quadTo(float f, float f2, float f3, float f4) {
        float f5;
        float[] fArray = this.middle;
        fArray[0] = this.cx0;
        fArray[1] = this.cy0;
        fArray[2] = f;
        fArray[3] = f2;
        fArray[4] = f3;
        fArray[5] = f4;
        float f6 = fArray[4];
        float f7 = fArray[5];
        float f8 = fArray[2] - fArray[0];
        float f9 = fArray[3] - fArray[1];
        float f10 = fArray[4] - fArray[2];
        float f11 = fArray[5] - fArray[3];
        if (f8 == 0.0f && f9 == 0.0f || f10 == 0.0f && f11 == 0.0f) {
            f8 = f10 = fArray[4] - fArray[0];
            f9 = f11 = fArray[5] - fArray[1];
        }
        if (f8 == 0.0f && f9 == 0.0f) {
            this.lineTo(fArray[0], fArray[1]);
            return;
        }
        if (Math.abs(f8) < 0.1f && Math.abs(f9) < 0.1f) {
            f5 = (float)Math.sqrt(f8 * f8 + f9 * f9);
            f8 /= f5;
            f9 /= f5;
        }
        if (Math.abs(f10) < 0.1f && Math.abs(f11) < 0.1f) {
            f5 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            f10 /= f5;
            f11 /= f5;
        }
        Stroker.computeOffset(f8, f9, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, f8, f9, this.cmx, this.cmy, this.offset0[0], this.offset0[1]);
        int n = Stroker.findSubdivPoints(this.curve, fArray, this.subdivTs, 6, this.lineWidth2);
        float[] fArray2 = this.lp;
        float[] fArray3 = this.rp;
        int n2 = 0;
        Curve.BreakPtrIterator breakPtrIterator = this.curve.breakPtsAtTs(fArray, 6, this.subdivTs, n);
        while (breakPtrIterator.hasNext()) {
            int n3 = breakPtrIterator.next();
            n2 = this.computeOffsetQuad(fArray, n3, fArray2, fArray3);
            this.emitLineTo(fArray2[0], fArray2[1]);
            switch (n2) {
                case 6: {
                    this.emitQuadTo(fArray2[2], fArray2[3], fArray2[4], fArray2[5]);
                    this.emitQuadToRev(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                    break;
                }
                case 4: {
                    this.emitLineTo(fArray2[2], fArray2[3]);
                    this.emitLineToRev(fArray3[0], fArray3[1]);
                    break;
                }
            }
            this.emitLineToRev(fArray3[n2 - 2], fArray3[n2 - 1]);
        }
        this.cmx = (fArray2[n2 - 2] - fArray3[n2 - 2]) / 2.0f;
        this.cmy = (fArray2[n2 - 1] - fArray3[n2 - 1]) / 2.0f;
        this.cdx = f10;
        this.cdy = f11;
        this.cx0 = f6;
        this.cy0 = f7;
        this.prev = 1;
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Stroker doesn't use a native consumer");
    }

    static final class PolyStack {
        private static final byte TYPE_LINETO = 0;
        private static final byte TYPE_QUADTO = 1;
        private static final byte TYPE_CUBICTO = 2;
        float[] curves;
        int end;
        byte[] curveTypes;
        int numCurves;
        final RendererContext rdrCtx;
        private final float[] curves_initial = new float[8193];
        private final byte[] curveTypes_initial = new byte[8193];
        int curveTypesUseMark;
        int curvesUseMark;

        PolyStack(RendererContext rendererContext) {
            this.rdrCtx = rendererContext;
            this.curves = this.curves_initial;
            this.curveTypes = this.curveTypes_initial;
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.DO_STATS) {
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
        }

        void dispose() {
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.DO_STATS) {
                this.rdrCtx.stats.stat_rdr_poly_stack_types.add(this.curveTypesUseMark);
                this.rdrCtx.stats.stat_rdr_poly_stack_curves.add(this.curvesUseMark);
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            if (this.curves != this.curves_initial) {
                this.rdrCtx.putDirtyFloatArray(this.curves);
                this.curves = this.curves_initial;
            }
            if (this.curveTypes != this.curveTypes_initial) {
                this.rdrCtx.putDirtyByteArray(this.curveTypes);
                this.curveTypes = this.curveTypes_initial;
            }
        }

        private void ensureSpace(int n) {
            if (this.curves.length - this.end < n) {
                if (MarlinConst.DO_STATS) {
                    this.rdrCtx.stats.stat_array_stroker_polystack_curves.add(this.end + n);
                }
                this.curves = this.rdrCtx.widenDirtyFloatArray(this.curves, this.end, this.end + n);
            }
            if (this.curveTypes.length <= this.numCurves) {
                if (MarlinConst.DO_STATS) {
                    this.rdrCtx.stats.stat_array_stroker_polystack_curveTypes.add(this.numCurves + 1);
                }
                this.curveTypes = this.rdrCtx.widenDirtyByteArray(this.curveTypes, this.numCurves, this.numCurves + 1);
            }
        }

        void pushCubic(float f, float f2, float f3, float f4, float f5, float f6) {
            this.ensureSpace(6);
            this.curveTypes[this.numCurves++] = 2;
            float[] fArray = this.curves;
            int n = this.end;
            fArray[n++] = f5;
            fArray[n++] = f6;
            fArray[n++] = f3;
            fArray[n++] = f4;
            fArray[n++] = f;
            fArray[n++] = f2;
            this.end = n;
        }

        void pushQuad(float f, float f2, float f3, float f4) {
            this.ensureSpace(4);
            this.curveTypes[this.numCurves++] = 1;
            float[] fArray = this.curves;
            int n = this.end;
            fArray[n++] = f3;
            fArray[n++] = f4;
            fArray[n++] = f;
            fArray[n++] = f2;
            this.end = n;
        }

        void pushLine(float f, float f2) {
            this.ensureSpace(2);
            this.curveTypes[this.numCurves++] = 0;
            this.curves[this.end++] = f;
            this.curves[this.end++] = f2;
        }

        void popAll(PathConsumer2D pathConsumer2D) {
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] byArray = this.curveTypes;
            float[] fArray = this.curves;
            int n = this.numCurves;
            int n2 = this.end;
            block5: while (n != 0) {
                switch (byArray[--n]) {
                    case 0: {
                        pathConsumer2D.lineTo(fArray[n2 -= 2], fArray[n2 + 1]);
                        continue block5;
                    }
                    case 1: {
                        pathConsumer2D.quadTo(fArray[(n2 -= 4) + 0], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3]);
                        continue block5;
                    }
                    case 2: {
                        pathConsumer2D.curveTo(fArray[(n2 -= 6) + 0], fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4], fArray[n2 + 5]);
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        public String toString() {
            String string = "";
            int n = this.numCurves;
            int n2 = this.end;
            while (n != 0) {
                int n3;
                switch (this.curveTypes[--n]) {
                    case 0: {
                        n3 = 2;
                        string = string + "line: ";
                        break;
                    }
                    case 1: {
                        n3 = 4;
                        string = string + "quad: ";
                        break;
                    }
                    case 2: {
                        n3 = 6;
                        string = string + "cubic: ";
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
                string = string + Arrays.toString(Arrays.copyOfRange(this.curves, n2 -= n3, n2 + n3)) + "\n";
            }
            return string;
        }
    }
}

