/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.awt.SunToolkit;
import sun.font.GlyphList;
import sun.font.XRGlyphCache;
import sun.font.XRGlyphCacheEntry;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.GlyphListPipe;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;

public class XRTextRenderer
extends GlyphListPipe {
    static final int MAX_ELT_GLYPH_COUNT = 253;
    XRGlyphCache glyphCache;
    XRCompositeManager maskBuffer;
    XRBackend backend;
    GrowableEltArray eltList;

    public XRTextRenderer(XRCompositeManager xRCompositeManager) {
        this.glyphCache = new XRGlyphCache(xRCompositeManager);
        this.maskBuffer = xRCompositeManager;
        this.backend = xRCompositeManager.getBackend();
        this.eltList = new GrowableEltArray(64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawGlyphList(SunGraphics2D sunGraphics2D, GlyphList glyphList) {
        if (glyphList.getNumGlyphs() == 0) {
            return;
        }
        try {
            int n;
            XRSurfaceData xRSurfaceData;
            SunToolkit.awtLock();
            try {
                xRSurfaceData = (XRSurfaceData)sunGraphics2D.surfaceData;
            }
            catch (ClassCastException classCastException) {
                throw new InvalidPipeException("wrong surface data type: " + sunGraphics2D.surfaceData);
            }
            xRSurfaceData.validateAsDestination(null, sunGraphics2D.getCompClip());
            xRSurfaceData.maskBuffer.validateCompositeState(sunGraphics2D.composite, sunGraphics2D.transform, sunGraphics2D.paint, sunGraphics2D);
            float f = glyphList.getX();
            float f2 = glyphList.getY();
            int n2 = 0;
            int n3 = 0;
            if (glyphList.isSubPixPos()) {
                f += 0.1666667f;
                f2 += 0.1666667f;
            } else {
                f += 0.5f;
                f2 += 0.5f;
            }
            XRGlyphCacheEntry[] xRGlyphCacheEntryArray = this.glyphCache.cacheGlyphs(glyphList);
            boolean bl = false;
            int n4 = xRGlyphCacheEntryArray[0].getGlyphSet();
            int n5 = -1;
            glyphList.startGlyphIteration();
            float[] fArray = glyphList.getPositions();
            for (n = 0; n < glyphList.getNumGlyphs(); ++n) {
                glyphList.setGlyphIndex(n);
                XRGlyphCacheEntry xRGlyphCacheEntry = xRGlyphCacheEntryArray[n];
                this.eltList.getGlyphs().addInt(xRGlyphCacheEntry.getGlyphID());
                int n6 = xRGlyphCacheEntry.getGlyphSet();
                bl |= n6 == this.glyphCache.lcdGlyphSet;
                int n7 = 0;
                int n8 = 0;
                if (glyphList.usePositions() || xRGlyphCacheEntry.getXAdvance() != (float)xRGlyphCacheEntry.getXOff() || xRGlyphCacheEntry.getYAdvance() != (float)xRGlyphCacheEntry.getYOff() || n6 != n4 || n5 < 0 || this.eltList.getCharCnt(n5) == 253) {
                    n5 = this.eltList.getNextIndex();
                    this.eltList.setCharCnt(n5, 1);
                    n4 = n6;
                    this.eltList.setGlyphSet(n5, n6);
                    if (glyphList.usePositions()) {
                        float f3 = fArray[n * 2] + f;
                        float f4 = fArray[n * 2 + 1] + f2;
                        n7 = (int)Math.floor(f3);
                        n8 = (int)Math.floor(f4);
                        f -= (float)xRGlyphCacheEntry.getXOff();
                        f2 -= (float)xRGlyphCacheEntry.getYOff();
                    } else {
                        n7 = (int)Math.floor(f);
                        n8 = (int)Math.floor(f2);
                        f += xRGlyphCacheEntry.getXAdvance() - (float)xRGlyphCacheEntry.getXOff();
                        f2 += xRGlyphCacheEntry.getYAdvance() - (float)xRGlyphCacheEntry.getYOff();
                    }
                    this.eltList.setXOff(n5, n7 - n2);
                    this.eltList.setYOff(n5, n8 - n3);
                    n2 = n7;
                    n3 = n8;
                    continue;
                }
                this.eltList.setCharCnt(n5, this.eltList.getCharCnt(n5) + 1);
            }
            n = bl ? 0 : 2;
            this.maskBuffer.compositeText(xRSurfaceData, (int)glyphList.getX(), (int)glyphList.getY(), 0, n, this.eltList);
            this.eltList.clear();
        }
        finally {
            SunToolkit.awtUnlock();
        }
    }
}

