/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import sun.font.CCompositeGlyphMapper;
import sun.font.CFont;
import sun.font.CompositeFont;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.PhysicalFont;

public final class CCompositeFont
extends CompositeFont {
    private final List<CFont> fallbackFonts = new ArrayList<CFont>();

    public CCompositeFont(CFont cFont) {
        super(new PhysicalFont[]{cFont});
        this.mapper = new CCompositeGlyphMapper(this);
    }

    @Override
    public synchronized int getNumSlots() {
        return super.getNumSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CFont getSlotFont(int n) {
        if (n == 0) {
            return (CFont)super.getSlotFont(0);
        }
        CCompositeFont cCompositeFont = this;
        synchronized (cCompositeFont) {
            return this.fallbackFonts.get(n - 1);
        }
    }

    @Override
    synchronized FontStrike getStrike(FontStrikeDesc fontStrikeDesc, boolean bl) {
        return super.getStrike(fontStrikeDesc, bl);
    }

    @Override
    synchronized void removeFromCache(FontStrikeDesc fontStrikeDesc) {
        super.removeFromCache(fontStrikeDesc);
    }

    @Override
    protected synchronized int getValidatedGlyphCode(int n) {
        return super.getValidatedGlyphCode(n);
    }

    @Override
    public boolean hasSupplementaryChars() {
        return false;
    }

    @Override
    public boolean useAAForPtSize(int n) {
        return true;
    }

    public synchronized int findSlot(String string) {
        for (int i = 0; i < this.numSlots; ++i) {
            CFont cFont = this.getSlotFont(i);
            if (!string.equals(cFont.getNativeFontName())) continue;
            return i;
        }
        return -1;
    }

    public synchronized int addSlot(CFont cFont) {
        int n = this.findSlot(cFont.getNativeFontName());
        if (n >= 0) {
            return n;
        }
        this.fallbackFonts.add(cFont);
        this.lastFontStrike = new SoftReference<Object>(null);
        this.strikeCache.clear();
        return this.numSlots++;
    }
}

